/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.delta;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.threerings.delta.BareArrayMask;
import com.threerings.delta.ClassMappingProvider;
import com.threerings.delta.Delta;
import com.threerings.delta.DeltaFinal;
import com.threerings.expr.MutableInteger;
import com.threerings.io.ArrayMask;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.tudey.util.ObjectMap;
import com.threerings.tudey.util.Pool;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReflectiveDelta
extends Delta
implements Pool.Poolable {
    protected transient ClassMapping _cmap;
    protected Class<?> _clazz;
    protected BareArrayMask _mask;
    protected Object[] _values;
    protected static ObjectMap<Class<?>, ClassMapping> _classes = new ObjectMap();
    protected static final Map<Class<?>, FieldHandler> PRIMITIVE_FIELD_HANDLERS = ImmutableMap.builder().put(Boolean.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            boolean nvalue = field.getBoolean(revised);
            if (field.getBoolean(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeBoolean(((Boolean)values[vidx.value++]).booleanValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readBoolean());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            boolean value = mask.isSet(midx.value++) ? ((Boolean)values[vidx.value++]).booleanValue() : field.getBoolean(original);
            field.setBoolean(revised, value);
        }
    }).put(Byte.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            byte nvalue = field.getByte(revised);
            if (field.getByte(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeByte((int)((Byte)values[vidx.value++]).byteValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readByte());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            byte value = mask.isSet(midx.value++) ? ((Byte)values[vidx.value++]).byteValue() : field.getByte(original);
            field.setByte(revised, value);
        }
    }).put(Character.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            char nvalue = field.getChar(revised);
            if (field.getChar(original) != nvalue) {
                mask.set(idx);
                values.add(Character.valueOf(nvalue));
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeChar((int)((Character)values[vidx.value++]).charValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(Character.valueOf(in.readChar()));
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            char value = mask.isSet(midx.value++) ? ((Character)values[vidx.value++]).charValue() : field.getChar(original);
            field.setChar(revised, value);
        }
    }).put(Double.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            double nvalue = field.getDouble(revised);
            if (field.getDouble(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeDouble(((Double)values[vidx.value++]).doubleValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readDouble());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            double value = mask.isSet(midx.value++) ? ((Double)values[vidx.value++]).doubleValue() : field.getDouble(original);
            field.setDouble(revised, value);
        }
    }).put(Float.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            float nvalue = field.getFloat(revised);
            if (field.getFloat(original) != nvalue) {
                mask.set(idx);
                values.add(Float.valueOf(nvalue));
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeFloat(((Float)values[vidx.value++]).floatValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(Float.valueOf(in.readFloat()));
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            float value = mask.isSet(midx.value++) ? ((Float)values[vidx.value++]).floatValue() : field.getFloat(original);
            field.setFloat(revised, value);
        }
    }).put(Integer.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            int nvalue = field.getInt(revised);
            if (field.getInt(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeInt(((Integer)values[vidx.value++]).intValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readInt());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            int value = mask.isSet(midx.value++) ? ((Integer)values[vidx.value++]).intValue() : field.getInt(original);
            field.setInt(revised, value);
        }
    }).put(Long.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            long nvalue = field.getLong(revised);
            if (field.getLong(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeLong(((Long)values[vidx.value++]).longValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readLong());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            long value = mask.isSet(midx.value++) ? ((Long)values[vidx.value++]).longValue() : field.getLong(original);
            field.setLong(revised, value);
        }
    }).put(Short.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            short nvalue = field.getShort(revised);
            if (field.getShort(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeShort((int)((Short)values[vidx.value++]).shortValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readShort());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            short value = mask.isSet(midx.value++) ? ((Short)values[vidx.value++]).shortValue() : field.getShort(original);
            field.setShort(revised, value);
        }
    }).build();
    protected static final Map<Class<?>, FieldHandler> FINAL_PRIMITIVE_FIELD_HANDLERS = ImmutableMap.builder().put(Boolean.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setBoolean(revised, field.getBoolean(original));
        }
    }).put(Byte.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setByte(revised, field.getByte(original));
        }
    }).put(Character.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setChar(revised, field.getChar(original));
        }
    }).put(Double.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setDouble(revised, field.getDouble(original));
        }
    }).put(Float.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setFloat(revised, field.getFloat(original));
        }
    }).put(Integer.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setInt(revised, field.getInt(original));
        }
    }).put(Long.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setLong(revised, field.getLong(original));
        }
    }).put(Short.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setShort(revised, field.getShort(original));
        }
    }).build();
    protected static final FieldHandler OBJECT_FIELD_HANDLER = new FieldHandler(){
        protected Object[] _oarray = new Object[1];
        protected Object[] _narray = new Object[1];

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            Object ovalue = this._oarray[0] = field.get(original);
            Object nvalue = this._narray[0] = field.get(revised);
            if (!Arrays.deepEquals(this._oarray, this._narray)) {
                if (Delta.checkDeltable(ovalue, nvalue)) {
                    nvalue = Delta.createDelta(ovalue, nvalue);
                }
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeObject(values[vidx.value++]);
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readObject());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            Object value;
            if (mask.isSet(midx.value++)) {
                if ((value = values[vidx.value++]) instanceof Delta) {
                    value = ((Delta)value).apply(field.get(original));
                }
            } else {
                value = field.get(original);
            }
            field.set(revised, value);
        }
    };
    protected static final FieldHandler FINAL_OBJECT_FIELD_HANDLER = new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.set(revised, field.get(original));
        }
    };

    public ReflectiveDelta(Object original, Object revised) {
        this.init(original, revised);
    }

    public void init(Object original, Object revised) {
        this._clazz = original.getClass();
        this._cmap = null;
        if (original instanceof ClassMappingProvider) {
            this._cmap = ((ClassMappingProvider)original).getClassMapping();
            if (this._cmap == null) {
                this._cmap = this.getInnerClassMapping(this._clazz);
            }
        } else {
            this._cmap = this.getInnerClassMapping(this._clazz);
        }
        this._mask = new BareArrayMask(this._cmap.getMaskLength());
        Field[] fields = this._cmap.getFields();
        FieldHandler[] handlers = this._cmap.getHandlers();
        ArrayList values = Lists.newArrayList();
        MutableInteger midx = new MutableInteger();
        int ii = 0;
        while (ii < fields.length) {
            try {
                handlers[ii].populate(fields[ii], original, revised, this._mask, midx, values);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta computation", e);
            }
            ++ii;
        }
        this._values = values.toArray();
    }

    public ReflectiveDelta() {
    }

    public boolean isEmpty() {
        return this._values.length == 0;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        _classStreamer.writeObject(this._clazz, out, true);
        this._mask.writeTo(out);
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        FieldHandler[] fieldHandlerArray = this.getInnerClassMapping(this._clazz).getHandlers();
        int n = fieldHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldHandler handler = fieldHandlerArray[n2];
            handler.write(this._mask, midx, this._values, vidx, out);
            ++n2;
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._clazz = (Class)_classStreamer.createObject(in);
        ClassMapping cmap = this.getInnerClassMapping(this._clazz);
        this._mask = new BareArrayMask(cmap.getMaskLength());
        this._mask.readFrom(in);
        ArrayList values = Lists.newArrayList();
        MutableInteger midx = new MutableInteger();
        FieldHandler[] fieldHandlerArray = cmap.getHandlers();
        int n = fieldHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldHandler handler = fieldHandlerArray[n2];
            handler.read(this._mask, midx, values, in);
            ++n2;
        }
        this._values = values.toArray();
    }

    @Override
    public Object apply(Object original) {
        Object revised;
        if (original.getClass() != this._clazz) {
            throw new IllegalArgumentException("Delta class mismatch: original is " + original.getClass() + ", expected " + this._clazz);
        }
        try {
            revised = this._clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + this._clazz + " for delta application", e);
        }
        ClassMapping cmap = this.getInnerClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        int ii = 0;
        while (ii < fields.length) {
            try {
                handlers[ii].apply(fields[ii], original, revised, this._mask, midx, this._values, vidx);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta application", e);
            }
            ++ii;
        }
        return revised;
    }

    @Override
    public Delta merge(Delta other) {
        if (!(other instanceof ReflectiveDelta)) {
            throw new IllegalArgumentException("Cannot merge delta " + other);
        }
        ReflectiveDelta merged = new ReflectiveDelta();
        this.populateMerged((ReflectiveDelta)other, merged);
        return merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[class=").append(this._clazz.getName());
        ClassMapping cmap = this.getInnerClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        int ii = 0;
        while (ii < fields.length) {
            handlers[ii].toString(fields[ii], this._mask, midx, this._values, vidx, buf);
            ++ii;
        }
        return buf.append("]").toString();
    }

    @Override
    public void reset() {
        this._clazz = null;
        this._cmap = null;
        this._mask = null;
        this._values = null;
    }

    protected void populateMerged(ReflectiveDelta other, ReflectiveDelta merged) {
        if (this._clazz != other._clazz) {
            throw new IllegalArgumentException("Merge class mismatch: other is " + other._clazz + ", expected " + this._clazz);
        }
        merged._clazz = this._clazz;
        int mlength = this.getInnerClassMapping(this._clazz).getMaskLength();
        merged._mask = new BareArrayMask(mlength);
        ArrayList values = Lists.newArrayList();
        int ii = 0;
        int oidx = 0;
        int nidx = 0;
        while (ii < mlength) {
            block11: {
                Object value;
                block10: {
                    block9: {
                        if (!this._mask.isSet(ii)) break block9;
                        Object ovalue = this._values[oidx++];
                        if (other._mask.isSet(ii)) {
                            Object nvalue;
                            if ((nvalue = other._values[nidx++]) instanceof Delta) {
                                Delta ndelta = (Delta)nvalue;
                                value = ovalue instanceof Delta ? ((Delta)ovalue).merge(ndelta) : ndelta.apply(ovalue);
                            } else {
                                value = nvalue;
                            }
                        } else {
                            value = ovalue;
                        }
                        break block10;
                    }
                    if (!other._mask.isSet(ii)) break block11;
                    value = other._values[nidx++];
                }
                merged._mask.set(ii);
                values.add(value);
            }
            ++ii;
        }
        merged._values = values.toArray();
    }

    protected ClassMapping getInnerClassMapping(Class<?> clazz) {
        if (this._cmap == null) {
            this._cmap = ReflectiveDelta.getClassMapping(clazz);
            return this._cmap;
        }
        return this._cmap;
    }

    public static ClassMapping getClassMapping(Class<?> clazz) {
        ClassMapping _cmap = _classes.get(clazz);
        if (_cmap == null) {
            _cmap = new ClassMapping(clazz);
            _classes.put(clazz, _cmap);
        }
        return _cmap;
    }

    protected static void collectFields(Class<?> clazz, List<Field> fields) {
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != Object.class) {
            ReflectiveDelta.collectFields(sclazz, fields);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!(Modifier.isStatic(mods) || Modifier.isTransient(mods) || field.isSynthetic())) {
                field.setAccessible(true);
                fields.add(field);
            }
            ++n2;
        }
    }

    public static class ClassMapping {
        protected Field[] _fields;
        protected FieldHandler[] _handlers;
        protected int _maskLength;

        public ClassMapping(Class<?> clazz) {
            ArrayList fields = Lists.newArrayList();
            ReflectiveDelta.collectFields(clazz, fields);
            this._fields = fields.toArray(new Field[fields.size()]);
            this._handlers = new FieldHandler[this._fields.length];
            int ii = 0;
            while (ii < this._fields.length) {
                Field field = this._fields[ii];
                Class<?> type = field.getType();
                if (Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(DeltaFinal.class)) {
                    this._handlers[ii] = type.isPrimitive() ? FINAL_PRIMITIVE_FIELD_HANDLERS.get(type) : FINAL_OBJECT_FIELD_HANDLER;
                } else {
                    ++this._maskLength;
                    this._handlers[ii] = type.isPrimitive() ? PRIMITIVE_FIELD_HANDLERS.get(type) : OBJECT_FIELD_HANDLER;
                }
                ++ii;
            }
        }

        public Field[] getFields() {
            return this._fields;
        }

        public FieldHandler[] getHandlers() {
            return this._handlers;
        }

        public int getMaskLength() {
            return this._maskLength;
        }
    }

    protected static abstract class FieldHandler {
        protected FieldHandler() {
        }

        public abstract void populate(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, List<Object> var6) throws IllegalAccessException;

        public abstract void write(ArrayMask var1, MutableInteger var2, Object[] var3, MutableInteger var4, ObjectOutputStream var5) throws IOException;

        public abstract void read(ArrayMask var1, MutableInteger var2, List<Object> var3, ObjectInputStream var4) throws IOException, ClassNotFoundException;

        public abstract void apply(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, Object[] var6, MutableInteger var7) throws IllegalAccessException;

        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
            if (mask.isSet(midx.value++)) {
                buf.append(", " + field.getName() + "=" + values[vidx.value++]);
            }
        }
    }

    protected static abstract class FinalFieldHandler
    extends FieldHandler {
        protected FinalFieldHandler() {
        }

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) {
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) {
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) {
        }

        @Override
        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
        }
    }
}

