/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.google.common.collect.ImmutableList;
import com.threerings.export.Exporter;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.util.MoreObjects;
import java.util.EnumSet;

public enum ExporterReplacers implements Exporter.Replacer
{
    COMPOUND_SHAPE_CONFIG{

        @Override
        public Exporter.Replacement getReplacement(Object value, Class<?> clazz) {
            if (value instanceof ShapeConfig.Compound && clazz != ShapeConfig.Compound.class) {
                ShapeConfig.Compound cc = (ShapeConfig.Compound)value;
                if (cc.shapes.length == 1) {
                    ShapeConfig.TransformedShape ts = cc.shapes[0];
                    if (ts.transform.equals(new ShapeConfig.TransformedShape().transform)) {
                        return new Exporter.Replacement(ts.shape, clazz);
                    }
                    ShapeConfig.Transformed repl = new ShapeConfig.Transformed();
                    repl.shape = ts.shape;
                    repl.transform = ts.transform;
                    return new Exporter.Replacement(repl, clazz);
                }
            }
            return null;
        }
    }
    ,
    COMPOUND_ACTION_CONFIG{

        @Override
        public Exporter.Replacement getReplacement(Object value, Class<?> clazz) {
            if (value instanceof ActionConfig.Compound && clazz != ActionConfig.Compound.class) {
                ActionConfig.Compound ac = (ActionConfig.Compound)value;
                switch (ac.actions.length) {
                    case 0: {
                        return new Exporter.Replacement(new ActionConfig.None(), clazz);
                    }
                    case 1: {
                        return new Exporter.Replacement(ac.actions[0], clazz);
                    }
                }
            }
            return null;
        }
    };


    private ExporterReplacers() {
    }

    public static Exporter.Replacer getAll() {
        return ExporterReplacers.compound(EnumSet.allOf(ExporterReplacers.class));
    }

    public static Exporter.Replacer compound(Iterable<? extends Exporter.Replacer> itr) {
        final ImmutableList replacers = ImmutableList.copyOf(itr);
        return new Exporter.Replacer(){

            @Override
            public Exporter.Replacement getReplacement(Object value, Class<?> clazz) {
                for (Exporter.Replacer replacer : replacers) {
                    Exporter.Replacement repl = replacer.getReplacement(value, clazz);
                    if (repl == null) continue;
                    Exporter.Replacement replRepl = this.getReplacement(repl.value, repl.clazz);
                    return MoreObjects.firstNonNull(replRepl, repl);
                }
                return null;
            }
        };
    }

    /* synthetic */ ExporterReplacers(String string, int n, ExporterReplacers exporterReplacers) {
        this();
    }
}

