/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.MapMaker;
import com.google.common.collect.SetMultimap;
import com.samskivert.util.ObserverList;
import com.samskivert.util.WeakObserverList;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.editor.Editable;
import com.threerings.editor.Strippable;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.Validator;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.expr.Scope;
import com.threerings.resource.ResourceManager;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public abstract class ManagedConfig
extends DeepObject
implements Exportable,
ConfigUpdateListener<ManagedConfig>,
ResourceManager.ModificationObserver {
    protected String _name;
    @DeepOmit
    protected transient ConfigManager _cfgmgr;
    @DeepOmit
    protected transient WeakObserverList<ConfigUpdateListener<ManagedConfig>> _listeners;
    @DeepOmit
    protected transient boolean _firing;
    @DeepOmit
    protected transient ArrayList<ManagedConfig> _updateConfigs;
    @DeepOmit
    protected transient HashSet<String> _updateResources;
    protected static Map<ManagedConfig, String> _comments;

    static {
        ManagedConfig.setStoreComments(true);
    }

    public static void setStoreComments(boolean storeComments) {
        if (storeComments != (_comments != null)) {
            _comments = storeComments ? new MapMaker().concurrencyLevel(1).weakKeys().makeMap() : null;
        }
    }

    @Editable
    public final Class<?> getConfigType() {
        return this.getClass();
    }

    @Editable(editor="configType", weight=-1.7976931348623157E308)
    public final void setConfigType(Class<?> val) {
    }

    @Editable
    @Strippable
    public String getComment() {
        String comm;
        if (_comments != null && (comm = _comments.get(this)) != null) {
            return comm;
        }
        return "";
    }

    @Editable(height=3, width=40, collapsible=true, weight=-8.988465674311579E307)
    @Strippable
    public void setComment(String comment) {
        if (_comments != null) {
            if ("".equals(comment)) {
                _comments.remove(this);
            } else {
                _comments.put(this, comment);
            }
        }
    }

    @Override
    public Object copy(Object dest, Object outer) {
        Object result = super.copy(dest, outer);
        ((ManagedConfig)result).setComment(this.getComment());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getComment().equals(((ManagedConfig)other).getComment());
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public ConfigReference<? extends ManagedConfig> getReference() {
        return new ConfigReference(this._name);
    }

    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    public ConfigGroup<ManagedConfig> getConfigGroup() {
        return this._cfgmgr.getGroup(this);
    }

    public final ManagedConfig getInstance(String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getInstance(null, firstKey, firstValue, otherArgs);
    }

    public final ManagedConfig getInstance(Scope scope, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getInstance(scope, new ArgumentMap(firstKey, firstValue, otherArgs));
    }

    public final ManagedConfig getInstance(Scope scope) {
        return this.getInstance(scope, null);
    }

    public final ManagedConfig getInstance(ArgumentMap args) {
        return this.getInstance(null, args);
    }

    public ManagedConfig getInstance(Scope scope, ArgumentMap args) {
        return this;
    }

    public ManagedConfig getOriginalCopy() {
        return (ManagedConfig)this.clone();
    }

    public void addListener(ConfigUpdateListener<?> listener) {
        if (this._listeners == null) {
            this._listeners = WeakObserverList.newSafeInOrder();
            this._listeners.setCheckDuplicates(false);
            this.addUpdateDependencies();
        }
        ConfigUpdateListener<?> mlistener = listener;
        this._listeners.add(mlistener);
    }

    public void removeListener(ConfigUpdateListener<?> listener) {
        if (this._listeners != null) {
            ConfigUpdateListener<?> mlistener = listener;
            this._listeners.remove(mlistener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
                this.clearUpdateDependencies();
            }
        }
    }

    public void init(ConfigManager cfgmgr) {
        this._cfgmgr = cfgmgr;
    }

    public void updateFromSource(EditorContext ctx, boolean force) {
    }

    public void wasUpdated() {
        if (this._updateConfigs != null) {
            this.clearUpdateDependencies();
            this.addUpdateDependencies();
        }
        this.fireConfigUpdated();
    }

    public boolean validateReferences(Validator validator) {
        return validator.validate(this._cfgmgr, this);
    }

    public void validateOuters(String where) {
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        this.fireConfigUpdated();
    }

    public void resourceModified(String path, long lastModified) {
        this.fireConfigUpdated();
    }

    public void writeFields(Exporter out) throws IOException {
        String comment = this.getComment();
        if (!"".equals(comment)) {
            out.write("comment", comment);
        }
        out.defaultWriteFields();
    }

    public void readFields(Importer in) throws IOException {
        in.defaultReadFields();
        this.setComment(in.read("comment", ""));
    }

    @Deprecated
    protected void getUpdateReferences(ConfigReferenceSet refs) {
    }

    protected void getUpdateResources(HashSet<String> paths) {
    }

    protected void fireConfigUpdated() {
        if (this._firing) {
            return;
        }
        this._firing = true;
        try {
            if (this._listeners != null) {
                final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, this);
                this._listeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigUpdateListener<ManagedConfig>>(){

                    public boolean apply(ConfigUpdateListener<ManagedConfig> listener) {
                        listener.configUpdated(event);
                        return true;
                    }
                });
            }
            this.maybeFireOnConfigManager();
        }
        finally {
            this._firing = false;
        }
    }

    protected void maybeFireOnConfigManager() {
        if (this._cfgmgr != null) {
            ConfigManager mgr = this._cfgmgr.isResourceClass(this.getClass()) ? this._cfgmgr.getRoot() : this._cfgmgr;
            mgr.fireConfigUpdated(this);
        }
    }

    protected void addUpdateDependencies() {
        ConfigReferenceSet.Default refSet = new ConfigReferenceSet.Default();
        this.getUpdateReferences(refSet);
        SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> refs = ((ConfigReferenceSet)refSet).getRefsMap();
        this._updateConfigs = new ArrayList(refs.size());
        for (Map.Entry entry : refs.asMap().entrySet()) {
            Class mclass = (Class)entry.getKey();
            for (ConfigReference ref : (Collection)entry.getValue()) {
                ConfigReference mref = ref;
                Object config = this._cfgmgr.getConfig(mclass, mref);
                if (config == null) continue;
                ((ManagedConfig)config).addListener(this);
                this._updateConfigs.add((ManagedConfig)config);
            }
        }
        this._updateResources = new HashSet<String>();
        this.getUpdateResources(this._updateResources);
        ResourceManager rsrcmgr = this._cfgmgr.getResourceManager();
        for (String path : this._updateResources) {
            rsrcmgr.addModificationObserver(path, (ResourceManager.ModificationObserver)this);
        }
    }

    protected void clearUpdateDependencies() {
        int ii = 0;
        int nn = this._updateConfigs.size();
        while (ii < nn) {
            this._updateConfigs.get(ii).removeListener(this);
            ++ii;
        }
        this._updateConfigs = null;
        ResourceManager rsrcmgr = this._cfgmgr.getResourceManager();
        if (this._updateResources != null) {
            for (String path : this._updateResources) {
                rsrcmgr.removeModificationObserver(path, (ResourceManager.ModificationObserver)this);
            }
        }
        this._updateResources = null;
    }
}

