/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.ObserverList;
import com.samskivert.util.PropertiesUtil;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.util.Validator;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.expr.Scope;
import com.threerings.resource.ResourceManager;
import com.threerings.util.CacheUtil;
import com.threerings.util.Copyable;
import com.threerings.util.MessageManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigManager
implements Copyable,
Exportable {
    protected String _type;
    protected ConfigManager _parent;
    protected ConfigManager _top;
    protected ResourceManager _rsrcmgr;
    protected MessageManager _msgmgr;
    protected String _configPath;
    protected HashMap<Class<?>, ConfigGroup<?>> _groups = new HashMap();
    protected Map<String, ManagedConfig> _resources;
    protected HashMap<String, Class<?>[]> _classes;
    protected ObserverList<ConfigUpdateListener<ManagedConfig>> _updateListeners;
    protected boolean _ignoreUpdates;

    public ConfigManager(ResourceManager rsrcmgr, MessageManager msgmgr, String configPath) {
        this._type = "global";
        this._rsrcmgr = rsrcmgr;
        this._msgmgr = msgmgr;
        this._configPath = String.valueOf(configPath) + (configPath.endsWith("/") ? "" : "/");
    }

    public ConfigManager() {
    }

    public boolean isInitialized() {
        return this._resources != null;
    }

    public void init() {
        this.init(new Consumer<Exception>(){

            @Override
            public void accept(Exception e) {
            }
        });
    }

    public void init(Consumer<Exception> exceptionConsumer) {
        try {
            this.loadManagerProperties();
        }
        catch (IOException e) {
            exceptionConsumer.accept(e);
            ClydeLog.log.warning((Object)"Failed to load manager properties.", new Object[]{e});
            return;
        }
        this._resources = CacheUtil.softValues();
        Class<?>[] classes = this._classes.get("global");
        if (classes == null) {
            return;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz;
            Class<?> cclass = clazz = classArray[n2];
            this.registerGroup(cclass, exceptionConsumer);
            ++n2;
        }
    }

    public void init(String type, ConfigManager parent) {
        this._type = type;
        this._parent = parent;
        this._rsrcmgr = parent._rsrcmgr;
        this._msgmgr = parent._msgmgr;
        this._resources = parent._resources;
        this._classes = parent._classes;
        HashMap<Class<?>, ConfigGroup<?>> ogroups = this._groups;
        this._groups = new HashMap();
        Class<?>[] classes = this._classes.get(type);
        if (classes == null) {
            return;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            ConfigGroup<?> group = ogroups.get(clazz);
            if (group == null) {
                Class<?> cclass = clazz;
                group = new ConfigGroup(cclass);
            }
            group.init(this);
            this._groups.put(clazz, group);
            ++n2;
        }
    }

    public String getType() {
        return this._type;
    }

    public ConfigManager getParent() {
        return this._parent;
    }

    public ConfigManager getTop() {
        return this._top;
    }

    public ConfigManager getRoot() {
        return this._parent == null ? this : this._parent.getRoot();
    }

    public ResourceManager getResourceManager() {
        return this._rsrcmgr;
    }

    public MessageManager getMessageManager() {
        return this._msgmgr;
    }

    public String getConfigPath() {
        return this._configPath;
    }

    public boolean isResourceClass(Class<?> clazz) {
        return ListUtil.contains((Object[])this.getResourceClasses(), clazz);
    }

    public Class<?>[] getResourceClasses() {
        return this._classes.get("resource");
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, String name) {
        return this.getConfig(clazz, name, null, null);
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, ConfigReference<T> ref) {
        return this.getConfig(clazz, ref, null);
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, ConfigReference<T> ref, Scope scope) {
        return ref == null ? null : (T)this.getConfig(clazz, ref.getName(), scope, ref.getArguments());
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getConfig(clazz, name, null, firstKey, firstValue, otherArgs);
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getConfig(clazz, name, scope, new ArgumentMap(firstKey, firstValue, otherArgs));
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope) {
        return this.getConfig(clazz, name, scope, null);
    }

    public final <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, ArgumentMap args) {
        return this.getConfig(clazz, name, null, args);
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope, ArgumentMap args) {
        ManagedConfig cfg;
        if (name == null) {
            return null;
        }
        if (this.isResourceClass(clazz)) {
            cfg = this.getResourceConfig(name);
            if (cfg != null && !clazz.isInstance(cfg)) {
                throw new ClassCastException("[config=" + name + ", expected=" + clazz + ", actual=" + cfg.getClass() + "]");
            }
        } else {
            ConfigGroup<T> group = this.getGroup(clazz);
            ManagedConfig managedConfig = cfg = group == null ? null : group.getRawConfig(name);
            if (cfg == null) {
                return this._parent == null ? (this.getTop() == null || this.getTop() == this ? null : (T)this.getTop().getCurrentConfig(clazz, name, scope, args)) : (T)this._parent.getConfig(clazz, name, scope, args);
            }
        }
        if (cfg != null) {
            cfg = cfg.getInstance(scope, args);
        }
        return (T)((ManagedConfig)clazz.cast(cfg));
    }

    public <T extends ManagedConfig> T getCurrentConfig(Class<T> clazz, String name, Scope scope, ArgumentMap args) {
        ManagedConfig config;
        ConfigGroup<T> group = this.getGroup(clazz);
        if (group != null && (config = group.getRawConfig(name)) != null) {
            if ((config = config.getInstance(scope, args)) != null) {
                config = config.getInstance(scope, args);
            }
            return (T)((ManagedConfig)clazz.cast(config));
        }
        return null;
    }

    public ManagedConfig getRawConfig(Class<? extends ManagedConfig> clazz, String name) {
        ManagedConfig config;
        if (name == null || this.isResourceClass(clazz)) {
            return this.getConfig(clazz, name);
        }
        ConfigGroup<? extends ManagedConfig> group = this.getGroup(clazz);
        if (group != null && (config = group.getRawConfig(name)) != null) {
            return config;
        }
        return this._parent == null ? null : this._parent.getRawConfig(clazz, name);
    }

    public ManagedConfig getResourceConfig(String name) {
        ManagedConfig config = this._resources.get(name);
        if (config == null) {
            BinaryImporter in = null;
            try {
                InputStream is = this._rsrcmgr.getResource(name);
                if (is == null) {
                    return null;
                }
                try {
                    in = new BinaryImporter(is);
                    config = (ManagedConfig)in.readObject();
                    this._resources.put(name, config);
                    config.setName(name);
                    config.init(this.getTop() == null ? this.getRoot() : this.getTop());
                }
                catch (FileNotFoundException fnfe) {
                    return null;
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)"Failed to load config from resource.", new Object[]{"name", name, e});
                    try {
                        this._rsrcmgr.invalidResource(name);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return config;
    }

    public <T extends ManagedConfig> ConfigGroup<T>[] getGroups(Class<T> clazz) {
        ArrayList<ConfigGroup<T>> groups = new ArrayList<ConfigGroup<T>>();
        ConfigManager cfgmgr = this;
        while (cfgmgr != null) {
            ConfigGroup<T> group = cfgmgr.getGroup(clazz);
            if (group != null) {
                groups.add(group);
            }
            cfgmgr = cfgmgr.getParent();
        }
        ConfigGroup[] array = new ConfigGroup[groups.size()];
        return groups.toArray(array);
    }

    public <T extends ManagedConfig> ConfigGroup<T> getGroup(Class<T> clazz) {
        ConfigGroup<?> group = this._groups.get(clazz);
        return group;
    }

    public ConfigGroup<ManagedConfig> getGroup(ManagedConfig instance) {
        Class<Object> clazz;
        Class<Object> c = clazz = instance instanceof DerivedConfig ? ((DerivedConfig)instance).cclass : instance.getClass();
        while (c != ManagedConfig.class) {
            ConfigGroup<ManagedConfig> group = this._groups.get(c);
            if (group != null) {
                ConfigGroup<ManagedConfig> ret = group;
                return ret;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public ConfigGroup<?>[] getGroups(String name) {
        ArrayList groups = new ArrayList();
        ConfigManager cfgmgr = this;
        while (cfgmgr != null) {
            ConfigGroup<?> group = cfgmgr.getGroup(name, false);
            if (group != null) {
                groups.add(group);
            }
            cfgmgr = cfgmgr.getParent();
        }
        return groups.toArray(new ConfigGroup[groups.size()]);
    }

    public ConfigGroup<?> getGroup(String name) {
        return this.getGroup(name, true);
    }

    public ConfigGroup<?> getGroup(String name, boolean forward) {
        for (ConfigGroup<?> group : this._groups.values()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return forward && this._parent != null ? this._parent.getGroup(name) : null;
    }

    public Collection<ConfigGroup<?>> getGroups() {
        return new Ordering<ConfigGroup<?>>(){

            public int compare(ConfigGroup<?> g1, ConfigGroup<?> g2) {
                return g1.getName().compareTo(g2.getName());
            }
        }.immutableSortedCopy(this._groups.values());
    }

    public void addUpdateListener(ConfigUpdateListener<?> listener) {
        if (this._updateListeners == null) {
            this._updateListeners = ObserverList.newFastUnsafe();
        }
        ConfigUpdateListener<?> mlistener = listener;
        this._updateListeners.add(mlistener);
    }

    public void removeUpdateListener(ConfigUpdateListener<?> listener) {
        if (this._updateListeners != null) {
            ConfigUpdateListener<?> mlistener = listener;
            this._updateListeners.remove(mlistener);
            if (this._updateListeners.isEmpty()) {
                this._updateListeners = null;
            }
        }
    }

    public void saveAll() {
        for (ConfigGroup<?> group : this._groups.values()) {
            group.save();
        }
    }

    public void saveAll(File dir, String extension, boolean xml) {
        for (ConfigGroup<?> group : this._groups.values()) {
            group.save(new File(dir, String.valueOf(group.getName()) + extension), xml);
        }
    }

    public void revertAll() {
        for (ConfigGroup<?> group : this._groups.values()) {
            group.revert();
        }
    }

    public ManagedConfig updateResourceConfig(String name, ManagedConfig config) {
        ManagedConfig oconfig = this._resources.get(name);
        if (oconfig == null) {
            this._resources.put(name, config);
            return config;
        }
        if (!config.equals(oconfig)) {
            config.copy(oconfig);
            oconfig.wasUpdated();
        }
        return oconfig;
    }

    public boolean validateReferences(Validator validator) {
        boolean result = true;
        for (ConfigGroup<?> group : this.getGroups()) {
            validator.pushWhere(group.getName());
            try {
                for (ManagedConfig config : group.getRawConfigs()) {
                    validator.pushWhere(config.getName());
                    try {
                        result &= config.validateReferences(validator);
                    }
                    finally {
                        validator.popWhere();
                    }
                }
            }
            finally {
                validator.popWhere();
            }
        }
        return result;
    }

    public void refresh(Class<? extends ManagedConfig> clazz) {
        ConfigGroup<? extends ManagedConfig>[] groups = this.getGroups(clazz);
        if (groups.length > 0) {
            ConfigGroup<? extends ManagedConfig>[] configGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigGroup<? extends ManagedConfig> group = configGroupArray[n2];
                for (ManagedConfig config : group.getRawConfigs()) {
                    this.refresh(config);
                }
                ++n2;
            }
            return;
        }
        for (ManagedConfig oconfig : Lists.newArrayList(this._resources.values())) {
            ManagedConfig nconfig;
            if (!clazz.isInstance(oconfig)) continue;
            String name = oconfig.getName();
            BinaryImporter in = null;
            try {
                try {
                    in = new BinaryImporter(this._rsrcmgr.getResource(name));
                    nconfig = (ManagedConfig)in.readObject();
                    nconfig.setName(name);
                    nconfig.init(this.getRoot());
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)"Failed to refresh config from resource.", new Object[]{"name", name, e});
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            nconfig.copy(oconfig);
            this.refresh(oconfig);
        }
    }

    public void setTop(ConfigManager cfmgr) {
        this._top = cfmgr;
    }

    public void writeFields(Exporter out) throws IOException {
        ArrayList list = Lists.newArrayList();
        for (ConfigGroup<?> group : this.getGroups()) {
            if (Iterables.isEmpty(group.getRawConfigs())) continue;
            list.add(group);
        }
        ConfigGroup[] groups = (ConfigGroup[])Iterables.toArray((Iterable)list, ConfigGroup.class);
        out.write("groups", groups, new ConfigGroup[0], ConfigGroup[].class);
    }

    public void readFields(Importer in) throws IOException {
        ConfigGroup[] groups;
        ConfigGroup[] configGroupArray = groups = in.read("groups", new ConfigGroup[0], ConfigGroup[].class);
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigGroup group = configGroupArray[n2];
            this._groups.put(group.getConfigClass(), group);
            ++n2;
        }
    }

    @Override
    public Object copy(Object dest) {
        return this.copy(dest, null);
    }

    @Override
    public Object copy(Object dest, Object outer) {
        ConfigManager other = dest instanceof ConfigManager ? (ConfigManager)dest : new ConfigManager();
        for (ConfigGroup<?> group : this._groups.values()) {
            Class<?> clazz = group.getConfigClass();
            ConfigGroup<?> ogroup = other._groups.get(clazz);
            other._groups.put(clazz, (ConfigGroup)group.copy(ogroup));
        }
        return other;
    }

    protected void loadManagerProperties() throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = this._rsrcmgr.getResource(String.valueOf(this._configPath) + "manager.properties");
        }
        catch (IOException ioe) {
            in = this._rsrcmgr.getResource(String.valueOf(this._configPath) + "manager.txt");
        }
        props.load(in);
        in.close();
        this._classes = new HashMap();
        Object[] types = StringUtil.parseStringArray((String)props.getProperty("types", ""));
        Object[] objectArray = types = (String[])ArrayUtil.append((Object[])types, (Object)"resource");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object type = objectArray[n2];
            Properties tprops = PropertiesUtil.getSubProperties((Properties)props, (String)type);
            String[] names = StringUtil.parseStringArray((String)tprops.getProperty("classes", ""));
            Class[] classes = new Class[names.length];
            int ii = 0;
            while (ii < names.length) {
                try {
                    classes[ii] = Class.forName(names[ii]);
                }
                catch (ClassNotFoundException e) {
                    throw (IOException)new IOException("Error initializing manager.").initCause(e);
                }
                ++ii;
            }
            this._classes.put((String)type, classes);
            ++n2;
        }
    }

    protected <T extends ManagedConfig> void registerGroup(Class<T> clazz, Consumer<Exception> exceptionConsumer) {
        ConfigGroup<T> group = new ConfigGroup<T>(clazz);
        group.init(this, exceptionConsumer);
        this._groups.put(clazz, group);
    }

    protected void refresh(ManagedConfig config) {
        this._ignoreUpdates = true;
        try {
            config.wasUpdated();
        }
        finally {
            this._ignoreUpdates = false;
        }
    }

    protected void fireConfigUpdated(ManagedConfig config) {
        if (this._updateListeners != null && !this._ignoreUpdates) {
            final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, config);
            this._updateListeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigUpdateListener<ManagedConfig>>(){

                public boolean apply(ConfigUpdateListener<ManagedConfig> listener) {
                    listener.configUpdated(event);
                    return true;
                }
            });
        }
    }

    protected ManagedConfig[] toSaveableArray(Class<? extends ManagedConfig> groupClass, Iterable<? extends ManagedConfig> configs, Class<? extends ManagedConfig> arrayElementClass) {
        Class<? extends ManagedConfig> clazz = arrayElementClass;
        return (ManagedConfig[])Iterables.toArray((Iterable)new Ordering<ManagedConfig>(){

            public int compare(ManagedConfig c1, ManagedConfig c2) {
                return c1.getName().compareTo(c2.getName());
            }
        }.immutableSortedCopy(configs), clazz);
    }

    protected Exporter.Replacer getSaveReplacer(ConfigGroup<?> group) {
        return null;
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

