package com.threerings.tudey.shape;

import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;

public class Ring extends Compound {


    /** The center of the circle. */
    protected Vector2f _center = new Vector2f();
    /** The radius of the inner circle. */
    public float _innerRadius;
    
    /** The radius of the outer circle. */
    public float _outerRadius;
	
	/**
     * Creates a compound containing the supplied shapes (which will be referenced, not copied).
     */
    public Ring (Vector2f center, float innerRadius,float outerRadius)
    {
    	this._center = center;
    	this._innerRadius = innerRadius;
    	this._outerRadius = outerRadius;
    	_shapes = new Shape[CIRCLE_SEGMENTS];
    	for (int ii = 0; ii < CIRCLE_SEGMENTS; ii++) {
            float angle = ii * CIRCLE_INCREMENT;
            Vector2f v1 = new Vector2f(
                _center.x + FloatMath.cos(angle) * innerRadius,
                _center.y + FloatMath.sin(angle) * innerRadius);
            Vector2f v2 = new Vector2f(
                    _center.x + FloatMath.cos(angle) * outerRadius,
                    _center.y + FloatMath.sin(angle) * outerRadius);
               
            angle = (ii+1) * CIRCLE_INCREMENT;
            
            Vector2f v3 = new Vector2f(
                    _center.x + FloatMath.cos(angle) * outerRadius,
                    _center.y + FloatMath.sin(angle) * outerRadius);
                Vector2f v4 = new Vector2f(
                        _center.x + FloatMath.cos(angle) * innerRadius,
                        _center.y + FloatMath.sin(angle) * innerRadius);
            
            _shapes[ii] = new Polygon(new Vector2f[] {v1,v2,v3,v4});
        }
	
        updateBounds();
    }
    
    public Ring ()
    {
    	
    }

}
