package com.threerings.tudey.client;

import java.util.Iterator;
import java.util.List;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigManager;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.data.TudeySceneModel;

public class PreloaderWorker extends Thread{
	private PreloadableSet preloader;
	private List<TudeySceneModel.Entry> _remaining;
	private int count;
	private ConfigManager _cfmgr;
	
	public PreloaderWorker(ConfigManager cfmgr ,TudeySceneModel model,PreloadableSet preloader) {
		this.preloader = preloader;
        _remaining = Lists.newArrayList(model.getEntries());
        count = _remaining.size();
        _cfmgr = cfmgr;
	}
	
	public void run() {
		Iterator<TudeySceneModel.Entry> it = _remaining.iterator();
		while(it.hasNext()) {
			TudeySceneModel.Entry entry = it.next();
			entry.getPreloads(_cfmgr, preloader);
			it.remove();
		}
	}
	
	public float getPercent() {
		if(count == 0) {
			return 1.0f;
		}
		return (float)(count - _remaining.size())/count;
	}
}
