package com.threerings.opengl.gui;

import java.util.Vector;

import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;

public class MovingTextLabel extends Label {
	
	public static class MovingObserver{
		public void update(MovingTextLabel label) {
			
		}
	}
	private Vector<MovingObserver> obs;
	protected int _deta = 0;
	protected boolean _left;
	protected int _xCoordinate ;

	 /**
     * Creates a label that will display the supplied text.
     */
    public MovingTextLabel (GlContext ctx, String text)
    {
        this(ctx, null, text);
    }
    
    public void setDeta(int deta) {
    	this._deta = deta;
    }
    
    public void setLeft(boolean left) {
    	this._left = left;
    }

    /**
     * Creates a label that will display the supplied icon.
     */
    public MovingTextLabel (GlContext ctx, Icon icon)
    {
        this(ctx, icon, null);
    }

    /**
     * Creates a label that will display the supplied text and icon (either or
     * both of which can be null).
     */
    public MovingTextLabel (GlContext ctx, Icon icon, String text)
    {
    	super(ctx,icon,text);
    	 obs = new Vector<MovingObserver>();
    	 if(_left) {
         	_xCoordinate = -getWidth();
         }else {
         	_xCoordinate = getWidth();
         }
    }
    
    
    public synchronized void addObserver(MovingObserver o) {
        if (o == null)
            throw new NullPointerException();
        if (!obs.contains(o)) {
            obs.addElement(o);
        }
    }

    protected void notifyObservers() {
        Object[] arrLocal;

        synchronized (this) {
            arrLocal = obs.toArray();
        }

        for (int i = arrLocal.length-1; i>=0; i--)
            ((MovingObserver)arrLocal[i]).update(this);
    }
    
    /**
     * Deletes an observer from the set of observers of this object.
     * Passing <CODE>null</CODE> to this method will have no effect.
     * @param   o   the observer to be deleted.
     */
    public synchronized void deleteObserver(MovingObserver o) {
        obs.removeElement(o);
    }
    
    protected void layout ()
    {
        super.layout();
    }
    
    protected void renderComponent (Renderer renderer)
    {
    	if(_left) {
    		_xCoordinate +=_deta;
    		
    		if (_xCoordinate > (getWidth()+_deta))
    		{
        		_xCoordinate = -getWidth();
        		notifyObservers();
    		}
    	}else {
    		_xCoordinate -=_deta;
    		
    		if(_xCoordinate < -(getWidth()+_deta)) {
    			_xCoordinate = getWidth();
    			notifyObservers();
    		}
    	}
    	
        _label.render(renderer, _xCoordinate, 0, getWidth(), getHeight(), _alpha);
    }

}
