/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.samskivert.util.ObjectUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.util.Copyable;
import com.threerings.util.Deep;
import com.threerings.util.DeepOmit;
import com.threerings.util.ReflectionUtil;
import com.threerings.util.Shallow;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DeepUtil {
    protected static final ObjectHandler IMMUTABLE_OBJECT_HANDLER = new ObjectHandler<Object>(){

        @Override
        public Object copy(Object source, Object dest, Object outer) throws IllegalAccessException {
            return source;
        }

        @Override
        public boolean equals(Object o1, Object o2) throws IllegalAccessException {
            return o1.equals(o2);
        }

        @Override
        public int hashCode(Object object) throws IllegalAccessException {
            return object.hashCode();
        }
    };
    protected static final Map<Class<?>, ObjectHandler> _objectHandlers = Maps.newConcurrentMap();
    protected static final ObjectHandler ARRAY_OBJECT_HANDLER;
    protected static final Map<Class<?>, FieldHandler> PRIMITIVE_FIELD_HANDLERS;
    protected static FieldHandler DEFAULT_OBJECT_FIELD_HANDLER;
    protected static FieldHandler DEEP_OBJECT_FIELD_HANDLER;
    protected static FieldHandler SHALLOW_OBJECT_FIELD_HANDLER;

    static {
        _objectHandlers.put(boolean[].class, new ObjectHandler<boolean[]>(){

            @Override
            public boolean[] copy(boolean[] source, boolean[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (boolean[])source.clone();
            }

            @Override
            public boolean equals(boolean[] o1, boolean[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(boolean[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(byte[].class, new ObjectHandler<byte[]>(){

            @Override
            public byte[] copy(byte[] source, byte[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (byte[])source.clone();
            }

            @Override
            public boolean equals(byte[] o1, byte[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(byte[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(char[].class, new ObjectHandler<char[]>(){

            @Override
            public char[] copy(char[] source, char[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (char[])source.clone();
            }

            @Override
            public boolean equals(char[] o1, char[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(char[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(double[].class, new ObjectHandler<double[]>(){

            @Override
            public double[] copy(double[] source, double[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (double[])source.clone();
            }

            @Override
            public boolean equals(double[] o1, double[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(double[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(float[].class, new ObjectHandler<float[]>(){

            @Override
            public float[] copy(float[] source, float[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (float[])source.clone();
            }

            @Override
            public boolean equals(float[] o1, float[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(float[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(int[].class, new ObjectHandler<int[]>(){

            @Override
            public int[] copy(int[] source, int[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (int[])source.clone();
            }

            @Override
            public boolean equals(int[] o1, int[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(int[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(long[].class, new ObjectHandler<long[]>(){

            @Override
            public long[] copy(long[] source, long[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (long[])source.clone();
            }

            @Override
            public boolean equals(long[] o1, long[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(long[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(short[].class, new ObjectHandler<short[]>(){

            @Override
            public short[] copy(short[] source, short[] dest, Object outer) throws IllegalAccessException {
                if (dest != null && dest.length == source.length) {
                    System.arraycopy(source, 0, dest, 0, source.length);
                    return dest;
                }
                return (short[])source.clone();
            }

            @Override
            public boolean equals(short[] o1, short[] o2) throws IllegalAccessException {
                return Arrays.equals(o1, o2);
            }

            @Override
            public int hashCode(short[] object) throws IllegalAccessException {
                return Arrays.hashCode(object);
            }
        });
        _objectHandlers.put(Boolean.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Byte.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Character.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Double.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Float.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Integer.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Long.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(Short.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(String.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(File.class, IMMUTABLE_OBJECT_HANDLER);
        _objectHandlers.put(ArgumentMap.class, new ArgumentHandler());
        _objectHandlers.put(HashMultiset.class, new HashMultisetHandler());
        _objectHandlers.put(Map.class, new MapHandler());
        ARRAY_OBJECT_HANDLER = new ObjectHandler<Object[]>(){

            @Override
            public Object[] copy(Object[] source, Object[] dest, Object outer) throws IllegalAccessException {
                if (dest == null || dest.length != source.length) {
                    dest = (Object[])Array.newInstance(source.getClass().getComponentType(), source.length);
                }
                int ii = 0;
                while (ii < source.length) {
                    dest[ii] = DeepUtil.copy(source[ii], dest[ii], outer);
                    ++ii;
                }
                return dest;
            }

            @Override
            public boolean equals(Object[] o1, Object[] o2) throws IllegalAccessException {
                if (o1.length != o2.length) {
                    return false;
                }
                int ii = 0;
                while (ii < o1.length) {
                    if (!DeepUtil.equals(o1[ii], o2[ii])) {
                        return false;
                    }
                    ++ii;
                }
                return true;
            }

            @Override
            public int hashCode(Object[] object) throws IllegalAccessException {
                int hash = 1;
                Object[] objectArray = object;
                int n = object.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    hash = 31 * hash + DeepUtil.hashCode(element);
                    ++n2;
                }
                return hash;
            }
        };
        PRIMITIVE_FIELD_HANDLERS = Maps.newHashMap();
        PRIMITIVE_FIELD_HANDLERS.put(Boolean.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setBoolean(dest, field.getBoolean(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getBoolean(o1) == field.getBoolean(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return field.getBoolean(object) ? 1231 : 1237;
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Byte.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setByte(dest, field.getByte(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getByte(o1) == field.getByte(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return field.getByte(object);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Character.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setChar(dest, field.getChar(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getChar(o1) == field.getChar(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return field.getChar(object);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Double.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setDouble(dest, field.getDouble(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getDouble(o1) == field.getDouble(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                long bits = Double.doubleToLongBits(field.getDouble(object));
                return (int)(bits ^ bits >>> 32);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Float.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setFloat(dest, field.getFloat(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getFloat(o1) == field.getFloat(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return Float.floatToIntBits(field.getFloat(object));
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Integer.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setInt(dest, field.getInt(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getInt(o1) == field.getInt(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return field.getInt(object);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Long.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setLong(dest, field.getLong(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getLong(o1) == field.getLong(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                long bits = field.getLong(object);
                return (int)(bits ^ bits >>> 32);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Short.TYPE, new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.setShort(dest, field.getShort(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.getShort(o1) == field.getShort(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return field.getShort(object);
            }
        });
        DEFAULT_OBJECT_FIELD_HANDLER = new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                Object v1 = field.get(source);
                Object v2 = field.get(dest);
                if (v1 == null) {
                    field.set(dest, null);
                } else if (v1 instanceof Copyable) {
                    field.set(dest, ((Copyable)v1).copy(v2, dest));
                } else {
                    field.set(dest, DeepUtil.copy(v1, v2, dest));
                }
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                Object v1 = field.get(o1);
                Object v2 = field.get(o2);
                if (v1 == null) {
                    return v2 == null;
                }
                if (v1.getClass().isArray()) {
                    return DeepUtil.equals(v1, v2);
                }
                return v1.equals(v2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                Object value = field.get(object);
                if (value == null) {
                    return 0;
                }
                if (value.getClass().isArray()) {
                    return DeepUtil.hashCode(value);
                }
                return value.hashCode();
            }
        };
        DEEP_OBJECT_FIELD_HANDLER = new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.set(dest, DeepUtil.copy(field.get(source), field.get(dest), dest));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return DeepUtil.equals(field.get(o1), field.get(o2));
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return DeepUtil.hashCode(field.get(object));
            }
        };
        SHALLOW_OBJECT_FIELD_HANDLER = new FieldHandler(){

            @Override
            public void copy(Field field, Object source, Object dest) throws IllegalAccessException {
                field.set(dest, field.get(source));
            }

            @Override
            public boolean equals(Field field, Object o1, Object o2) throws IllegalAccessException {
                return field.get(o1) == field.get(o2);
            }

            @Override
            public int hashCode(Field field, Object object) throws IllegalAccessException {
                return System.identityHashCode(field.get(object));
            }
        };
    }

    public static <T> T copy(T source) {
        return DeepUtil.copy(source, null);
    }

    public static <T> T copy(T source, T dest) {
        return DeepUtil.copy(source, dest, null);
    }

    public static <T> T copy(T source, T dest, Object outer) {
        if (source == null) {
            return null;
        }
        Class<?> clazz = source.getClass();
        if (dest != null && dest.getClass() != clazz) {
            dest = null;
        }
        ObjectHandler handler = DeepUtil.getObjectHandler(clazz);
        try {
            return handler.copy(source, dest, outer);
        }
        catch (IllegalAccessException e) {
            ClydeLog.log.warning((Object)"Couldn't access fields for deep copy.", new Object[]{e});
            return null;
        }
    }

    public static <T> T transfer(T source, T dest) {
        return DeepUtil.transfer(source, dest, null);
    }

    public static <T> T transfer(T source, T dest, Object outer) {
        Class<?> clazz = source.getClass();
        while (clazz != null && !clazz.isInstance(dest)) {
            clazz = clazz.getSuperclass();
        }
        ObjectHandler handler = DeepUtil.getObjectHandler(clazz);
        try {
            return handler.copy(source, dest, outer);
        }
        catch (IllegalAccessException e) {
            ClydeLog.log.warning((Object)"Couldn't access fields for deep copy.", new Object[]{e});
            return dest;
        }
    }

    public static <T> boolean equals(T o1, T o2) {
        Class<?> c2;
        if (o1 == o2) {
            return true;
        }
        Class<?> c1 = o1 == null ? null : o1.getClass();
        Class<?> clazz = c2 = o2 == null ? null : o2.getClass();
        if (c1 != c2) {
            return false;
        }
        ObjectHandler handler = DeepUtil.getObjectHandler(c1);
        try {
            return handler.equals(o1, o2);
        }
        catch (IllegalAccessException e) {
            ClydeLog.log.warning((Object)"Couldn't access fields for deep equals.", new Object[]{e});
            return false;
        }
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        ObjectHandler handler = DeepUtil.getObjectHandler(object.getClass());
        try {
            return handler.hashCode(object);
        }
        catch (IllegalAccessException e) {
            ClydeLog.log.warning((Object)"Couldn't access fields for deep hash code.", new Object[]{e});
            return 0;
        }
    }

    protected static ObjectHandler getObjectHandler(Class<?> clazz) {
        ObjectHandler handler = _objectHandlers.get(clazz);
        if (handler == null) {
            handler = Enum.class.isAssignableFrom(clazz) || ImmutableCollection.class.isAssignableFrom(clazz) || ImmutableMap.class.isAssignableFrom(clazz) || ImmutableMultimap.class.isAssignableFrom(clazz) ? IMMUTABLE_OBJECT_HANDLER : (clazz.isArray() ? ARRAY_OBJECT_HANDLER : new ReflectiveObjectHandler(clazz));
            _objectHandlers.put(clazz, handler);
        }
        return handler;
    }

    protected static void getInstanceFields(Class<?> clazz, ArrayList<Field> fields) {
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != Object.class) {
            DeepUtil.getInstanceFields(sclazz, fields);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!(Modifier.isStatic(mods) || field.isSynthetic() || field.isAnnotationPresent(DeepOmit.class))) {
                field.setAccessible(true);
                fields.add(field);
            }
            ++n2;
        }
    }

    protected static class ArgumentHandler
    extends ObjectHandler<ArgumentMap> {
        protected ArgumentHandler() {
        }

        @Override
        public ArgumentMap copy(ArgumentMap source, ArgumentMap dest, Object outer) throws IllegalAccessException {
            if (dest == null) {
                dest = new ArgumentMap();
            }
            source.copy(dest, outer);
            return dest;
        }

        @Override
        public boolean equals(ArgumentMap o1, ArgumentMap o2) throws IllegalAccessException {
            return o1.equals(o2);
        }

        @Override
        public int hashCode(ArgumentMap object) throws IllegalAccessException {
            return object.hashCode();
        }
    }

    protected static abstract class FieldHandler {
        protected FieldHandler() {
        }

        public abstract void copy(Field var1, Object var2, Object var3) throws IllegalAccessException;

        public abstract boolean equals(Field var1, Object var2, Object var3) throws IllegalAccessException;

        public abstract int hashCode(Field var1, Object var2) throws IllegalAccessException;
    }

    protected static class HashMultisetHandler
    extends ObjectHandler<HashMultiset> {
        protected HashMultisetHandler() {
        }

        @Override
        public HashMultiset copy(HashMultiset source, HashMultiset dest, Object outer) throws IllegalAccessException {
            if (dest == null) {
                dest = HashMultiset.create();
            }
            for (Object obj : source) {
                int count = source.count(obj);
                dest.add(DeepUtil.copy(obj), count);
            }
            return dest;
        }

        @Override
        public boolean equals(HashMultiset o1, HashMultiset o2) throws IllegalAccessException {
            return o1.equals((Object)o2);
        }

        @Override
        public int hashCode(HashMultiset object) throws IllegalAccessException {
            return object.hashCode();
        }
    }

    protected static class MapHandler
    extends ObjectHandler<Map> {
        protected MapHandler() {
        }

        @Override
        public Map<?, ?> copy(Map source, Map dest, Object outer) throws IllegalAccessException {
            if (dest == null) {
                dest = new HashMap();
            }
            for (Map.Entry obj : source.entrySet()) {
                dest.put(obj.getKey(), DeepUtil.copy(obj.getValue()));
            }
            return dest;
        }

        @Override
        public boolean equals(Map o1, Map o2) throws IllegalAccessException {
            return ObjectUtil.equals((Object)o1, (Object)o2);
        }

        @Override
        public int hashCode(Map object) throws IllegalAccessException {
            return object.hashCode();
        }
    }

    protected static abstract class ObjectHandler<T> {
        protected ObjectHandler() {
        }

        public abstract T copy(T var1, T var2, Object var3) throws IllegalAccessException;

        public abstract boolean equals(T var1, T var2) throws IllegalAccessException;

        public abstract int hashCode(T var1) throws IllegalAccessException;
    }

    protected static class ReflectiveObjectHandler
    extends ObjectHandler<Object> {
        protected Field[] _fields;
        protected FieldHandler[] _handlers;

        public ReflectiveObjectHandler(Class<?> clazz) {
            ArrayList<Field> fields = new ArrayList<Field>();
            DeepUtil.getInstanceFields(clazz, fields);
            this._fields = fields.toArray(new Field[fields.size()]);
            this._handlers = new FieldHandler[this._fields.length];
            int ii = 0;
            while (ii < this._fields.length) {
                Field field = this._fields[ii];
                Class<?> type = field.getType();
                this._handlers[ii] = type.isPrimitive() ? PRIMITIVE_FIELD_HANDLERS.get(type) : (field.getAnnotation(Deep.class) != null ? DEEP_OBJECT_FIELD_HANDLER : (field.getAnnotation(Shallow.class) != null ? SHALLOW_OBJECT_FIELD_HANDLER : DEFAULT_OBJECT_FIELD_HANDLER));
                ++ii;
            }
        }

        @Override
        public Object copy(Object source, Object dest, Object outer) throws IllegalAccessException {
            if (dest == null) {
                Object souter = ReflectionUtil.getOuter(source);
                Object douter = souter == null ? null : (outer == null ? souter : outer);
                dest = ReflectionUtil.newInstance(source.getClass(), douter);
                if (dest == null) {
                    return null;
                }
            }
            int ii = 0;
            while (ii < this._fields.length) {
                this._handlers[ii].copy(this._fields[ii], source, dest);
                ++ii;
            }
            return dest;
        }

        @Override
        public boolean equals(Object o1, Object o2) throws IllegalAccessException {
            int ii = 0;
            while (ii < this._fields.length) {
                if (!this._handlers[ii].equals(this._fields[ii], o1, o2)) {
                    return false;
                }
                ++ii;
            }
            return true;
        }

        @Override
        public int hashCode(Object object) throws IllegalAccessException {
            int hash = 1;
            int ii = 0;
            while (ii < this._fields.length) {
                hash = 31 * hash + this._handlers[ii].hashCode(this._fields[ii], object);
                ++ii;
            }
            return hash;
        }
    }
}

