/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.graph;

import com.threerings.math.Vector2f;
import java.util.LinkedHashMap;
import java.util.Map;

public class Node {
    private String name;
    private Vector2f location;
    private Map<Node, Integer> neighbors;
    private Node source;
    private boolean checked = false;
    private int heuristic;

    public Node(String name, Vector2f location, int heuristic) {
        this.name = name;
        this.location = location;
        this.heuristic = heuristic;
        this.neighbors = new LinkedHashMap<Node, Integer>();
    }

    public String getName() {
        return this.name;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public Node getSource() {
        return this.source;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public Vector2f getLocation() {
        return this.location;
    }

    public int getHeuristic() {
        return this.heuristic;
    }

    public void addNeighbor(Node neighbor, int distance) {
        this.neighbors.put(neighbor, distance);
    }

    public Map<Node, Integer> getNeighbors() {
        return this.neighbors;
    }

    public String toString() {
        String out = "";
        out = "[ name = " + this.name + ", neighbors = [ ";
        for (Node node : this.neighbors.keySet()) {
            out = String.valueOf(out) + node.getName() + " ";
        }
        out = String.valueOf(out) + "] ]";
        return out;
    }
}

