/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Vector3f;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.scene.config.ViewerEffectConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.CameraConfig;

@EditorTypes(value={Camera.class})
public abstract class TudeyViewerEffectConfig
extends ViewerEffectConfig {

    public static class Camera
    extends TudeyViewerEffectConfig {
        @Editable(min=0.0, step=0.01)
        public float transition;
        @Editable
        public Easing easing = new Easing.None();
        @Editable
        public CameraConfig camera = new CameraConfig();
        @Editable
        public CameraConfig[] cameras = new CameraConfig[0];

        @Override
        public void preload(GlContext ctx) {
        }

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            TudeySceneView view = ScopeUtil.resolve(scope, "view:this", null, TudeySceneView.class);
            if (view == null || !ScopeUtil.resolve(scope, "cameraEnabled", true).booleanValue()) {
                return Camera.getNoopEffect(effect);
            }
            if (effect instanceof CameraEffect) {
                ((CameraEffect)effect).setConfig(this);
            } else {
                effect = new CameraEffect(view, this);
            }
            return effect;
        }
    }

    public static class CameraEffect
    extends ViewerEffect {
        protected Vector3f _location = null;
        private TudeySceneView view;
        protected float _transition;
        protected Easing _easing;
        protected CameraConfig _camcfg;
        protected CameraConfig[] _camcfgs;
        protected boolean _activated;

        public CameraEffect(TudeySceneView view, Camera camera) {
            this.view = view;
            this._transition = camera.transition;
            this._camcfg = camera.camera;
            this._camcfgs = camera.cameras;
            this._easing = camera.easing;
        }

        public void setConfig(Camera camera) {
            CameraConfig cc;
            int n;
            int n2;
            CameraConfig[] cameraConfigArray;
            if (!this.view.isCameraEffectEnable()) {
                return;
            }
            if (this._camcfg == camera.camera) {
                return;
            }
            if (this._activated) {
                this.view.removeCameraConfig(this._camcfg, 0.0f, null, this._location);
                cameraConfigArray = this._camcfgs;
                n2 = this._camcfgs.length;
                n = 0;
                while (n < n2) {
                    cc = cameraConfigArray[n];
                    this.view.removeCameraConfig(cc, 0.0f, null, this._location);
                    ++n;
                }
            }
            this._transition = camera.transition;
            this._easing = camera.easing;
            this._camcfg = camera.camera;
            this._camcfgs = camera.cameras;
            if (this._activated) {
                this.view.addCameraConfig(this._camcfg, 0.0f, null, this._location);
                cameraConfigArray = this._camcfgs;
                n2 = this._camcfgs.length;
                n = 0;
                while (n < n2) {
                    cc = cameraConfigArray[n];
                    this.view.addCameraConfig(cc, 0.0f, null, this._location);
                    ++n;
                }
            }
        }

        @Override
        public void activate(Scene scene) {
            if (!this.view.isCameraEffectEnable()) {
                return;
            }
            this._activated = true;
            this.view.addCameraConfig(this._camcfg, this._transition, this._easing, this._location);
            if (this._camcfgs != null) {
                CameraConfig[] cameraConfigArray = this._camcfgs;
                int n = this._camcfgs.length;
                int n2 = 0;
                while (n2 < n) {
                    CameraConfig cc = cameraConfigArray[n2];
                    this.view.addCameraConfig(cc, 0.0f, null, this._location);
                    ++n2;
                }
            }
        }

        @Override
        public void deactivate() {
            if (!this.view.isCameraEffectEnable()) {
                return;
            }
            this.view.removeCameraConfig(this._camcfg, this._transition, this._easing);
            CameraConfig[] cameraConfigArray = this._camcfgs;
            int n = this._camcfgs.length;
            int n2 = 0;
            while (n2 < n) {
                CameraConfig cc = cameraConfigArray[n2];
                this.view.removeCameraConfig(cc, 0.0f, null);
                ++n2;
            }
            this._activated = false;
        }

        public void setLocation(Vector3f location) {
            if (Vector3f.ZERO.equals(location)) {
                return;
            }
            if (this._location == null) {
                this._location = new Vector3f();
            }
            this._location.set(location);
        }
    }
}

