/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.samskivert.util.ListUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.SimpleScope;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.config.GraphConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.TudeyContext;

public class GraphSprite
extends EntrySprite
implements ConfigUpdateListener<GraphConfig> {
    public static final String VERTEX_MODEL = "editor/marker/vertex/model_label.dat";
    public static final String EDGE_MODEL = "editor/marker/edge/model.dat";
    protected TudeySceneModel.GraphEntry _entry;
    protected GraphConfig _config = INVALID_CONFIG;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static GraphConfig INVALID_CONFIG = new GraphConfig();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public static float updateVertices(TudeySceneModel.Vertex[] vertices, Model[] models) {
        float minz = Float.MAX_VALUE;
        int ii = 0;
        while (ii < models.length) {
            TudeySceneModel.Vertex vertex = vertices[ii];
            Model model = models[ii];
            model.getLocalTransform().getTranslation().set(vertex.x, vertex.y, vertex.z);
            model.updateBounds();
            minz = Math.min(minz, vertex.z);
            ++ii;
        }
        return minz;
    }

    public static void updateEdges(TudeySceneModel.Vertex[] vertices, TudeySceneModel.Edge[] edges, Model[] models) {
        Vector3f translation = new Vector3f();
        Vector3f scale = new Vector3f();
        Vector3f vector = new Vector3f();
        Quaternion rotation = new Quaternion();
        int ii = 0;
        while (ii < models.length) {
            TudeySceneModel.Edge edge = edges[ii];
            TudeySceneModel.Vertex v1 = vertices[edge.start];
            TudeySceneModel.Vertex v2 = vertices[edge.end];
            vector.set(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
            float length = vector.length();
            if (length > 1.0E-6f) {
                rotation.fromAnglesXZ(FloatMath.asin(vector.z / length), FloatMath.atan2(-vector.x, vector.y));
            } else {
                rotation.set(Quaternion.IDENTITY);
            }
            Model model = models[ii];
            model.getLocalTransform().set(translation.set(v1.x, v1.y, v1.z), rotation, scale.set(1.0f, length, 1.0f));
            model.updateBounds();
            ++ii;
        }
    }

    public static Model[] maybeResize(Model[] omodels, int ncount, TudeyContext ctx, Scene scene, String name, ColorState colorState, Object userObject) {
        if (omodels.length == ncount) {
            return omodels;
        }
        Model[] nmodels = new Model[ncount];
        System.arraycopy(omodels, 0, nmodels, 0, Math.min(omodels.length, ncount));
        int ii = omodels.length;
        while (ii < ncount) {
            Model model = nmodels[ii] = new Model(ctx);
            model.setColorState(colorState);
            model.setUserObject(userObject);
            scene.add(model);
            model.setConfig(name, "index", "" + ii, new Object[0]);
            ++ii;
        }
        ii = ncount;
        while (ii < omodels.length) {
            scene.remove(omodels[ii]);
            ++ii;
        }
        return nmodels;
    }

    public GraphSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.GraphEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    public int getVertexIndex(Model model) {
        return this._impl.getVertexIndex(model);
    }

    public int getEdgeIndex(Model model) {
        return this._impl.getEdgeIndex(model);
    }

    @Override
    public void configUpdated(ConfigEvent<GraphConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.GraphEntry)entry;
        this.setConfig(this._entry.graph);
        this._impl.update(this._entry);
    }

    @Override
    public void setVisible(boolean visible) {
        this._impl.setVisible(visible);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<GraphConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(GraphConfig.class, ref));
    }

    protected void setConfig(GraphConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        GraphConfig.Original original = this._config == null ? null : this._config.getOriginal(this._ctx.getConfigManager());
        original = original == null ? GraphConfig.NULL_ORIGINAL : original;
        Implementation nimpl = original.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public int getVertexIndex(Model model) {
            return -1;
        }

        public int getEdgeIndex(Model model) {
            return -1;
        }

        public void update(TudeySceneModel.GraphEntry entry) {
        }

        public void setVisible(boolean visible) {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model[] _vertices = new Model[0];
        protected Model[] _edges = new Model[0];
        protected ColorState _colorState = new ColorState();
        protected ShapeSceneElement _footprint;
        @Bound
        protected Scene _scene;

        public Original(TudeyContext ctx, Scope parentScope, GraphConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this.setConfig(config);
        }

        public void setConfig(GraphConfig.Original config) {
            this._colorState.getColor().set(config.color);
            boolean selected = ((GraphSprite)this._parentScope).isSelected();
            if (selected && this._footprint == null) {
                this._footprint = new ShapeSceneElement((GlContext)this._ctx, true);
                this._footprint.getColor().set(SELECTED_COLOR);
                this._scene.add(this._footprint);
            } else if (!selected && this._footprint != null) {
                this._scene.remove(this._footprint);
                this._footprint = null;
            }
        }

        @Override
        public int getVertexIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._vertices, (Object)model);
        }

        @Override
        public int getEdgeIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._edges, (Object)model);
        }

        @Override
        public void update(TudeySceneModel.GraphEntry entry) {
            this._vertices = GraphSprite.maybeResize(this._vertices, entry.vertices.length, this._ctx, this._scene, GraphSprite.VERTEX_MODEL, this._colorState, this._parentScope);
            float minz = GraphSprite.updateVertices(entry.vertices, this._vertices);
            this._edges = GraphSprite.maybeResize(this._edges, entry.edges.length, this._ctx, this._scene, GraphSprite.EDGE_MODEL, this._colorState, this._parentScope);
            GraphSprite.updateEdges(entry.vertices, entry.edges, this._edges);
            if (this._footprint != null) {
                this._footprint.getTransform().getTranslation().z = minz;
                this._footprint.setShape(entry.createShape(this._ctx.getConfigManager()));
            }
        }

        @Override
        public void setVisible(boolean visible) {
            Model[] modelArray = this._vertices;
            int n = this._vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Model vertex = modelArray[n2];
                vertex.setVisible(visible);
                ++n2;
            }
            modelArray = this._edges;
            n = this._edges.length;
            n2 = 0;
            while (n2 < n) {
                Model edge = modelArray[n2];
                edge.setVisible(visible);
                ++n2;
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this._scene.removeAll(this._vertices);
            this._scene.removeAll(this._edges);
            if (this._footprint != null) {
                this._scene.remove(this._footprint);
            }
        }
    }
}

