/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material;

import com.samskivert.util.ArrayUtil;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Vector4f;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.ShallowObject;
import java.util.List;

public class Projection
extends ShallowObject {
    protected TechniqueConfig _technique;
    @Scoped
    protected ColorState _colorState;
    @Scoped
    protected Vector4f _genPlaneS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    @Scoped
    protected Vector4f _genPlaneT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    @Scoped
    protected Vector4f _genPlaneR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    @Scoped
    protected Vector4f _genPlaneQ = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

    public static TechniqueConfig rewrite(TechniqueConfig technique, Projection[] projections) {
        technique = (TechniqueConfig)technique.clone();
        TechniqueConfig.CompoundEnqueuer nenqueuer = new TechniqueConfig.CompoundEnqueuer();
        nenqueuer.enqueuers = new TechniqueConfig.Enqueuer[1 + projections.length];
        nenqueuer.enqueuers[0] = technique.enqueuer;
        technique.enqueuer = nenqueuer;
        int ii = 0;
        while (ii < projections.length) {
            Projection projection = projections[ii];
            TechniqueConfig ptech = projection.getTechnique();
            if (ptech.dependencies.length > 0) {
                technique.dependencies = (TechniqueConfig.TechniqueDependency[])ArrayUtil.concatenate((Object[])technique.dependencies, (Object[])ptech.dependencies);
            }
            nenqueuer.enqueuers[ii + 1] = ptech.enqueuer;
            ++ii;
        }
        return technique;
    }

    public Projection(TechniqueConfig technique, ColorState colorState) {
        this._technique = new TechniqueConfig();
        this._technique.dependencies = technique.dependencies;
        this._technique.enqueuer = new TechniqueConfig.EnqueuerWrapper(technique.enqueuer){

            @Override
            public Enqueueable createEnqueueable(GlContext ctx, Scope scope, Geometry geometry, boolean update, RenderQueue.Group group, List<Dependency.Adder> adders, MutableInteger pidx) {
                SimpleScope wscope = new SimpleScope(scope){

                    @Override
                    public <T> T get(String name, Class<T> clazz) {
                        return ScopeUtil.get(Projection.this, name, clazz);
                    }
                };
                return super.createEnqueueable(ctx, wscope, geometry, update, group, adders, pidx);
            }
        };
        this._colorState = colorState;
    }

    public TechniqueConfig getTechnique() {
        return this._technique;
    }

    public Vector4f getGenPlaneS() {
        return this._genPlaneS;
    }

    public Vector4f getGenPlaneT() {
        return this._genPlaneT;
    }

    public Vector4f getGenPlaneR() {
        return this._genPlaneR;
    }

    public Vector4f getGenPlaneQ() {
        return this._genPlaneQ;
    }
}

