/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Box;
import com.threerings.opengl.effect.FloatFunction;
import com.threerings.opengl.effect.ParticleGeometry;
import com.threerings.opengl.effect.ParticleSystem;
import com.threerings.opengl.effect.config.BaseParticleSystemConfig;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.geometry.config.DeformerConfig;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.probs.FloatFunctionVariable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.nio.ShortBuffer;

public class ParticleSystemConfig
extends BaseParticleSystemConfig {
    @Editable(editor="table")
    public Layer[] layers = new Layer[0];
    protected static final String DEFAULT_MATERIAL = "Model/Translucent";

    @Override
    public BaseParticleSystemConfig.Layer[] getLayers() {
        return this.layers;
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        if (impl instanceof ParticleSystem) {
            ((ParticleSystem)impl).setConfig(ctx, this);
        } else {
            impl = new ParticleSystem(ctx, scope, this);
        }
        return impl;
    }

    @Override
    public void invalidate() {
        Layer[] layerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.invalidate();
            ++n2;
        }
    }

    public static enum Alignment {
        FIXED,
        BILLBOARD,
        VELOCITY;

    }

    public static class GroupPriority
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0)
        public int group;
        @Editable
        public int priority;
    }

    public static class Layer
    extends BaseParticleSystemConfig.Layer {
        @Editable(category="appearance", weight=-0.5)
        public ParticleGeometryConfig geometry = new Points();
        @Editable(category="appearance", weight=-0.5)
        public Alignment alignment = Alignment.BILLBOARD;
        @Editable(category="appearance", weight=1.5, nullable=true)
        public ConfigReference<MaterialConfig> material = new ConfigReference("Model/Translucent");
        @Editable(category="appearance", weight=1.5, min=1.0)
        public int textureDivisionsS = 1;
        @Editable(category="appearance", weight=1.5, min=1.0)
        public int textureDivisionsT = 1;
        @Editable(category="appearance", weight=2.5)
        public boolean depthSort;
        @Editable(category="appearance", weight=2.5, nullable=true)
        public GroupPriority priorityMode;
        @Editable(category="appearance", weight=3.5, min=0.0, step=0.01)
        public FloatFunctionVariable length = new FloatFunctionVariable.Fixed(new FloatFunction.Constant(0.1f));
        @Editable(category="appearance", weight=3.5, min=0.0)
        public FloatFunctionVariable frame = new FloatFunctionVariable.Fixed(new FloatFunction.Constant(0.0f));
        @DeepOmit
        public transient SoftReference<float[]> data;
        @DeepOmit
        public transient SoftReference<ShortBuffer> indices;
        @DeepOmit
        public transient SoftReference<BufferObject> elementArrayBuffer;

        public void invalidate() {
            this.data = null;
            this.indices = null;
            this.elementArrayBuffer = null;
        }

        @Override
        public boolean shouldRotateOrientations() {
            return this.alignment == Alignment.FIXED;
        }

        @Override
        public void preload(GlContext ctx) {
            super.preload(ctx);
            new Preloadable.Config(MaterialConfig.class, this.material).preload(ctx);
        }
    }

    public static class Lines
    extends ParticleGeometryConfig {
        @Editable(min=0.0, hgroup="s")
        public int segments;
        @Editable(hgroup="s")
        public boolean moveTrailsWithParticles = true;

        public Lines(Quads quads) {
            this.segments = quads.segments;
        }

        public Lines() {
        }

        @Override
        public int getSegments() {
            return this.segments;
        }

        @Override
        public boolean getMoveTrailsWithParticles() {
            return this.moveTrailsWithParticles;
        }

        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, DeformerConfig deformer, PassDescriptor[] passes) {
            return this.segments > 0 ? new ParticleGeometry.LineTrails(ctx, scope, passes, this.segments) : new ParticleGeometry.Lines(ctx, scope, passes);
        }
    }

    public static class Meshes
    extends ParticleGeometryConfig {
        @Editable(mode="compact", nullable=true)
        public ConfigReference<ModelConfig> model;

        @Override
        public float getRadius(GlContext ctx) {
            GeometryConfig geom = this.getParticleGeometry(ctx);
            return geom == null ? 0.0f : geom.getBounds().getDiagonalLength() * 0.5f;
        }

        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, DeformerConfig deformer, PassDescriptor[] passes) {
            return ParticleGeometry.Meshes.create(ctx, scope, passes, this.getParticleGeometry(ctx));
        }

        protected GeometryConfig getParticleGeometry(GlContext ctx) {
            ModelConfig config = ctx.getConfigManager().getConfig(ModelConfig.class, this.model);
            return config == null ? null : config.getParticleGeometry(ctx);
        }
    }

    @EditorTypes(value={Points.class, Lines.class, Quads.class, Meshes.class})
    public static abstract class ParticleGeometryConfig
    extends GeometryConfig {
        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public int getSegments() {
            return 0;
        }

        public boolean getMoveTrailsWithParticles() {
            return true;
        }

        public float getRadius(GlContext ctx) {
            return 1.0f;
        }

        @Override
        public Box getBounds() {
            return Box.EMPTY;
        }
    }

    public static class Points
    extends ParticleGeometryConfig {
        @Override
        public float getRadius(GlContext ctx) {
            return 0.0f;
        }

        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, DeformerConfig deformer, PassDescriptor[] passes) {
            return new ParticleGeometry.Points(ctx, scope, passes);
        }
    }

    public static class Quads
    extends ParticleGeometryConfig {
        @Editable(min=0.0, hgroup="s")
        public int segments;
        @Editable(hgroup="s")
        public boolean moveTrailsWithParticles = true;

        public Quads(Lines lines) {
            this.segments = lines.segments;
        }

        public Quads() {
        }

        @Override
        public int getSegments() {
            return this.segments;
        }

        @Override
        public boolean getMoveTrailsWithParticles() {
            return this.moveTrailsWithParticles;
        }

        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, DeformerConfig deformer, PassDescriptor[] passes) {
            return this.segments > 0 ? new ParticleGeometry.QuadTrails(ctx, scope, passes, this.segments) : new ParticleGeometry.Quads(ctx, scope, passes);
        }
    }
}

