/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.math.Transform3D;
import com.threerings.opengl.effect.AlphaMode;
import com.threerings.opengl.effect.ColorFunction;
import com.threerings.opengl.effect.FloatFunction;
import com.threerings.opengl.effect.config.CounterConfig;
import com.threerings.opengl.effect.config.InfluenceConfig;
import com.threerings.opengl.effect.config.PlacerConfig;
import com.threerings.opengl.effect.config.ShooterConfig;
import com.threerings.opengl.model.config.InfluenceFlagConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.probs.ColorFunctionVariable;
import com.threerings.probs.FloatFunctionVariable;
import com.threerings.probs.FloatVariable;
import com.threerings.probs.QuaternionVariable;
import com.threerings.probs.VectorVariable;
import com.threerings.util.DeepObject;
import com.threerings.util.Shallow;
import java.io.IOException;

public abstract class BaseParticleSystemConfig
extends ModelConfig.Implementation
implements Preloadable.LoadableConfig {
    @Editable(hgroup="t")
    public SceneElement.TickPolicy tickPolicy = SceneElement.TickPolicy.DEFAULT;
    @Editable(min=0.0, step=0.01, hgroup="t")
    public float boundsExpansion;
    @Editable(min=0.0, step=0.01, hgroup="w")
    public float warmupTime;
    @Editable(min=0.0, step=0.01, hgroup="w")
    public float warmupGranularity = 0.1f;
    @Editable
    public ModelConfig.TransientPolicy transientPolicy = ModelConfig.TransientPolicy.FRUSTUM;
    @Editable
    public InfluenceFlagConfig influences = new InfluenceFlagConfig(true, false, false, false);

    @Override
    public void preload(GlContext ctx) {
        Layer[] layerArray = this.getLayers();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.preload(ctx);
            ++n2;
        }
    }

    public boolean anyLayersRespawn() {
        Layer[] layerArray = this.getLayers();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            if (layer.respawnDeadParticles) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public abstract Layer[] getLayers();

    public static abstract class Layer
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        @Editable(column=true)
        public String name = "";
        @Editable(column=true)
        public boolean visible = true;
        @Editable(category="appearance", weight=1.0, min=0.0)
        public int particleCount = 100;
        @Editable(category="appearance", weight=2.0)
        public AlphaMode alphaMode = AlphaMode.TRANSLUCENT;
        @Editable(category="appearance", weight=3.0, mode="alpha")
        public ColorFunctionVariable color = new ColorFunctionVariable.Fixed(new ColorFunction.Constant());
        @Editable(category="appearance", weight=3.0, min=0.0, step=0.01)
        public FloatFunctionVariable size = new FloatFunctionVariable.Fixed(new FloatFunction.Constant(0.1f));
        @Editable(category="origin", mode="rigid", step=0.01)
        public Transform3D transform = new Transform3D();
        @Editable(category="origin")
        public PlacerConfig placer = new PlacerConfig.Point();
        @Editable(category="origin")
        public QuaternionVariable orientation = new QuaternionVariable.Constant();
        @Editable(category="origin")
        public boolean rotateOrientationsWithEmitter;
        @Editable(category="origin")
        public boolean moveParticlesWithEmitter;
        @Editable(category="emission")
        public ShooterConfig shooter = new ShooterConfig.Cone();
        @Editable(category="emission", min=0.0, step=0.01)
        public FloatVariable speed = new FloatVariable.Uniform(1.0f, 1.5f);
        @Editable(category="emission", scale=0.017453292519943295)
        public VectorVariable angularVelocity = new VectorVariable.Constant();
        @Editable(category="emission")
        public boolean rotateVelocitiesWithEmitter = true;
        @Editable(category="flow")
        public CounterConfig counter = new CounterConfig.Unlimited();
        @Editable(category="flow")
        public boolean respawnDeadParticles = true;
        @Editable(category="world", min=0.0, step=0.01)
        public FloatVariable lifespan = new FloatVariable.Uniform(1.0f, 1.5f);
        @Editable(category="world", min=0.0, step=0.01)
        public float startTime;
        @Editable(category="world", min=0.0, step=0.01)
        public float timeScale = 1.0f;
        @Editable(category="influences")
        public InfluenceConfig[] influences = new InfluenceConfig[0];
        @Shallow
        public transient Layer identity = this;

        public abstract boolean shouldRotateOrientations();

        @Override
        public void preload(GlContext ctx) {
        }

        public void writeFields(Exporter out) throws IOException {
            out.defaultWriteFields();
            out.write("rotateOrientationsWithEmitter", this.rotateOrientationsWithEmitter);
        }

        public void readFields(Importer in) throws IOException {
            in.defaultReadFields();
            this.rotateOrientationsWithEmitter = in.read("rotateOrientationsWithEmitter", this.moveParticlesWithEmitter);
        }
    }
}

