/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.Reference;
import com.threerings.config.ReferenceConstraints;
import com.threerings.editor.Editable;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.export.ObjectMarshaller;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyUtil {
    protected static final Object STRIP_OUT = new Object();

    public static String getMode(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            String mode = lineage[ii].getMode();
            if (!"%INHERIT%".equals(mode)) {
                return mode;
            }
            --ii;
        }
        return "";
    }

    public static String getUnits(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            String units = lineage[ii].getUnits();
            if (!"%INHERIT%".equals(units)) {
                return units;
            }
            --ii;
        }
        return "";
    }

    public static double getMinimum(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double min = lineage[ii].getMinimum();
            if (min != Double.NEGATIVE_INFINITY) {
                return min;
            }
            --ii;
        }
        return -1.7976931348623157E308;
    }

    public static double getMaximum(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double max = lineage[ii].getMaximum();
            if (max != Double.NEGATIVE_INFINITY) {
                return max;
            }
            --ii;
        }
        return Double.MAX_VALUE;
    }

    public static double getStep(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double step = lineage[ii].getStep();
            if (step != Double.NEGATIVE_INFINITY) {
                return step;
            }
            --ii;
        }
        return 1.0;
    }

    public static double getScale(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double scale = lineage[ii].getScale();
            if (scale != Double.NEGATIVE_INFINITY) {
                return scale;
            }
            --ii;
        }
        return 1.0;
    }

    public static int getMinSize(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            int min = lineage[ii].getMinSize();
            if (min != Integer.MIN_VALUE) {
                return min;
            }
            --ii;
        }
        return 0;
    }

    public static int getMaxSize(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            int max = lineage[ii].getMaxSize();
            if (max != Integer.MIN_VALUE) {
                return max;
            }
            --ii;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isFixedSize(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            if (lineage[ii].isFixedSize()) {
                return true;
            }
            --ii;
        }
        return false;
    }

    public static Predicate<ManagedConfig> getRawConfigPredicate(ReferenceConstraints constraints) {
        if (constraints == null) {
            return Predicates.alwaysTrue();
        }
        final List<Class<? extends ManagedConfig>> vals = Arrays.asList(constraints.value());
        return new Predicate<ManagedConfig>(){

            public boolean apply(ManagedConfig cfg) {
                if (cfg instanceof DerivedConfig) {
                    cfg = cfg.getInstance((ArgumentMap)null);
                }
                Class<?> clazz = cfg.getClass();
                for (Class listedClass : vals) {
                    if (!listedClass.isAssignableFrom(clazz)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths) {
        PropertyUtil.getResources(cfgmgr, object, paths, new ReferenceSet());
    }

    public static void transferCompatibleProperties(Object source, Object dest) {
        Property[] destProps = Introspector.getProperties(dest);
        Property[] propertyArray = Introspector.getProperties(source);
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property srcProp = propertyArray[n2];
            String name = srcProp.getName();
            Property[] propertyArray2 = destProps;
            int n3 = destProps.length;
            int n4 = 0;
            while (n4 < n3) {
                Property destProp = propertyArray2[n4];
                if (name.equals(destProp.getName())) {
                    if (!srcProp.isCompatible(destProp)) break;
                    try {
                        destProp.set(dest, srcProp.get(source));
                    }
                    catch (Throwable t) {
                        Log.log.warning((Object)"Destination property not compatible after all?", new Object[]{t});
                    }
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static Object strip(ConfigManager cfgmgr, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] oarray;
            ArrayList list = Lists.newArrayList();
            Object[] objectArray = oarray = (Object[])object;
            int n = oarray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!PropertyUtil.isStrippable(element)) {
                    list.add(PropertyUtil.strip(cfgmgr, element));
                }
                ++n2;
            }
            int nsize = list.size();
            return list.toArray(oarray.length == nsize ? oarray : (Object[])Array.newInstance(oarray.getClass().getComponentType(), nsize));
        }
        if (object instanceof List) {
            List list = (List)object;
            int ii = list.size() - 1;
            while (ii >= 0) {
                Object element = list.get(ii);
                if (PropertyUtil.isStrippable(element)) {
                    list.remove(ii);
                } else {
                    list.set(ii, PropertyUtil.strip(cfgmgr, element));
                }
                --ii;
            }
            return list;
        }
        if (!(object instanceof Exportable)) {
            return object;
        }
        Class<?> clazz = object.getClass();
        Object prototype = ObjectMarshaller.getObjectMarshaller(clazz).getPrototype();
        Property[] propertyArray = Introspector.getProperties(clazz);
        int n = propertyArray.length;
        int n3 = 0;
        while (n3 < n) {
            Property property;
            Object result = PropertyUtil.strip(cfgmgr, object, property = propertyArray[n3]);
            property.set(object, result == STRIP_OUT ? property.get(prototype) : result);
            ++n3;
        }
        return object;
    }

    protected static Object strip(ConfigManager cfgmgr, Object object, Property property) {
        Object value = property.get(object);
        if (PropertyUtil.isStrippable(property) || PropertyUtil.isStrippable(value)) {
            return STRIP_OUT;
        }
        if (value == null) {
            return null;
        }
        if (property.getType().equals(ConfigReference.class)) {
            ArgumentMap args;
            Class<Object> cclass = property.getArgumentType(ConfigReference.class);
            ConfigReference ref = (ConfigReference)value;
            if (object instanceof DerivedConfig) {
                cclass = ((DerivedConfig)object).cclass;
            }
            if ((args = ref.getArguments()).isEmpty()) {
                return ref;
            }
            Object config = cfgmgr.getConfig(cclass, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                args.clear();
                return ref;
            }
            ParameterizedConfig pconfig = (ParameterizedConfig)config;
            Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Parameter param = pconfig.getParameter(entry.getKey());
                if (param == null) {
                    it.remove();
                    continue;
                }
                Property prop = param.getArgumentProperty(pconfig);
                if (prop == null) {
                    it.remove();
                    continue;
                }
                Object result = PropertyUtil.strip(cfgmgr, args, prop);
                if (result == STRIP_OUT) {
                    it.remove();
                    continue;
                }
                entry.setValue(result);
            }
            return ref;
        }
        return PropertyUtil.strip(cfgmgr, value);
    }

    protected static boolean isStrippable(Property property) {
        Class<?> type = property.getType();
        return property.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(type) || PropertyUtil.isStrippable(property.getComponentType()) || ConfigReference.class.isAssignableFrom(type) && PropertyUtil.isStrippable(property.getArgumentType(ConfigReference.class));
    }

    protected static boolean isStrippable(Object object) {
        return object != null && PropertyUtil.isStrippable(object.getClass());
    }

    protected static boolean isStrippable(Class<?> clazz) {
        return clazz != null && (clazz.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(clazz.getComponentType()) || PropertyUtil.isStrippable(clazz.getSuperclass()));
    }

    protected static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths, ReferenceSet refs) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                PropertyUtil.getResources(cfgmgr, element, paths, refs);
                ++n2;
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int ii = 0;
            int nn = list.size();
            while (ii < nn) {
                PropertyUtil.getResources(cfgmgr, list.get(ii), paths, refs);
                ++ii;
            }
            return;
        }
        Property[] propertyArray = Introspector.getProperties(object);
        int n = propertyArray.length;
        int n3 = 0;
        while (n3 < n) {
            block11: {
                String editor;
                Object value;
                block12: {
                    ConfigReference ref;
                    Class<Object> cclass;
                    block14: {
                        Property property;
                        block13: {
                            ConfigGroup<ManagedConfig> group;
                            boolean cfg;
                            property = propertyArray[n3];
                            value = property.get(object);
                            if (value == null) break block11;
                            Editable annotation = property.getAnnotation();
                            Reference refAnno = property.getAnnotation(Reference.class);
                            editor = annotation.editor();
                            boolean bl = cfg = editor.equals("config") || refAnno != null;
                            if (!cfg && !property.getType().equals(ConfigReference.class)) break block12;
                            if (!cfg) break block13;
                            ConfigGroup<ManagedConfig> configGroup = group = refAnno != null ? cfgmgr.getGroup(refAnno.value()) : cfgmgr.getGroup(annotation.mode());
                            if (group == null) break block11;
                            Class<ManagedConfig> mclass = group.getConfigClass();
                            cclass = mclass;
                            ref = new ConfigReference((String)value);
                            break block14;
                        }
                        Class<?> mclass = property.getArgumentType(ConfigReference.class);
                        ConfigReference mref = (ConfigReference)value;
                        cclass = mclass;
                        ref = mref;
                    }
                    if (refs.add(cclass, ref)) {
                        Object config;
                        if (cfgmgr.isResourceClass(cclass)) {
                            paths.add(ref.getName());
                        }
                        if ((config = cfgmgr.getConfig(cclass, ref)) != null) {
                            PropertyUtil.getResources(((ManagedConfig)config).getConfigManager(), config, paths, refs);
                        }
                    }
                    break block11;
                }
                if (editor.equals("resource")) {
                    paths.add((String)value);
                } else {
                    PropertyUtil.getResources(cfgmgr, value, paths, refs);
                }
            }
            ++n3;
        }
    }

    protected static class ReferenceSet {
        protected final SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> _set = HashMultimap.create();

        protected ReferenceSet() {
        }

        public boolean add(Class<? extends ManagedConfig> clazz, ConfigReference<?> ref) {
            return this._set.put(clazz, ref);
        }
    }
}

