/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.primitives.Primitives;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberEditor
extends PropertyEditor
implements ChangeListener {
    protected JSlider _slider;
    protected DraggableSpinner _spinner;
    protected JLabel _value;
    protected double _step;
    protected double _scale;

    @Override
    public void stateChanged(ChangeEvent event) {
        double value;
        if (event.getSource() == this._slider) {
            value = (double)this._slider.getValue() * this._step;
            this._spinner.setValue(value);
        } else {
            value = (Double)this._spinner.getValue();
            if (this._slider != null) {
                this._slider.setValue((int)Math.round(value / this._step));
            }
        }
        Number nvalue = this.fromDouble(value * this._scale);
        if (!this._property.get(this._object).equals(nvalue)) {
            this._property.set(this._object, nvalue);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        double value = ((Number)this._property.get(this._object)).doubleValue() / this._scale;
        if (this._property.getAnnotation().constant()) {
            this._value.setText(String.valueOf(this.fromDouble(value)));
            return;
        }
        this._spinner.setValue(value);
        if (this._slider != null) {
            this._slider.setValue((int)Math.round(value / this._step));
        }
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
        double min = this.getMinimum();
        double max = this.getMaximum();
        this._step = this.getStep();
        this._scale = this.getScale();
        if (this._property.getAnnotation().constant()) {
            this._value = new JLabel(" ");
            this.add(this._value);
        } else {
            if (this.getMode().equals("wide") && min != -1.7976931348623157E308 && max != Double.MAX_VALUE) {
                this._slider = new JSlider((int)Math.round(min / this._step), (int)Math.round(max / this._step));
                this.add(this._slider);
                this._slider.setBackground(null);
                this._slider.addChangeListener(this);
            }
            this._spinner = new DraggableSpinner(min, min, max, this._step);
            this.add(this._spinner);
            int width = this._property.getWidth(-1);
            if (width != -1) {
                ((JSpinner.NumberEditor)this._spinner.getEditor()).getTextField().setColumns(width);
                this._spinner.setPreferredSize(null);
            }
            this._spinner.addChangeListener(this);
        }
        this.addUnits((JPanel)((Object)this));
    }

    protected Number fromDouble(double value) {
        Class type = Primitives.unwrap(this._property.getType());
        if (type == Byte.TYPE) {
            return (byte)value;
        }
        if (type == Double.TYPE) {
            return value;
        }
        if (type == Float.TYPE) {
            return Float.valueOf((float)value);
        }
        if (type == Integer.TYPE) {
            return (int)value;
        }
        if (type == Long.TYPE) {
            return (long)value;
        }
        return (short)value;
    }

    @Override
    protected double getMinimum() {
        return Math.max(super.getMinimum(), this.getTypeMinimum());
    }

    @Override
    protected double getMaximum() {
        return Math.min(super.getMaximum(), this.getTypeMaximum());
    }

    protected double getTypeMinimum() {
        Class type = Primitives.unwrap(this._property.getType());
        if (type == Byte.TYPE) {
            return -128.0;
        }
        if (type == Double.TYPE) {
            return -1.7976931348623157E308;
        }
        if (type == Float.TYPE) {
            return -3.4028234663852886E38;
        }
        if (type == Integer.TYPE) {
            return -2.147483648E9;
        }
        if (type == Long.TYPE) {
            return -9.223372036854776E18;
        }
        return -32768.0;
    }

    protected double getTypeMaximum() {
        Class type = Primitives.unwrap(this._property.getType());
        if (type == Byte.TYPE) {
            return 127.0;
        }
        if (type == Double.TYPE) {
            return Double.MAX_VALUE;
        }
        if (type == Float.TYPE) {
            return 3.4028234663852886E38;
        }
        if (type == Integer.TYPE) {
            return 2.147483647E9;
        }
        if (type == Long.TYPE) {
            return 9.223372036854776E18;
        }
        return 32767.0;
    }
}

