/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.threerings.config.ConfigManager;
import com.threerings.config.tools.ConfigEditor;
import com.threerings.config.tools.ResourceEditor;
import com.threerings.editor.Introspector;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.FindDialog;
import com.threerings.editor.util.EditorContext;
import com.threerings.media.image.ColorPository;
import com.threerings.resource.ResourceManager;
import com.threerings.swing.LogPanel;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class BaseConfigEditor
extends JFrame
implements EditorContext,
ActionListener {
    protected ResourceManager _rsrcmgr;
    protected MessageManager _msgmgr;
    protected ConfigManager _cfgmgr;
    protected ColorPository _colorpos;
    protected MessageBundle _msgs;
    protected ToolUtil.EditablePrefs _eprefs;
    protected JDialog _pdialog;
    protected FindDialog _fdialog;
    protected Action _find;
    protected Action _findNext;
    protected static Preferences _prefs = Preferences.userNodeForPackage(BaseConfigEditor.class);

    public static BaseConfigEditor createEditor(EditorContext ctx, Class<?> clazz, String name) {
        if (ctx.getConfigManager().isResourceClass(clazz)) {
            return new ResourceEditor(ctx.getMessageManager(), ctx.getConfigManager().getRoot(), ctx.getColorPository(), ctx.getResourceManager().getResourceFile(name).toString());
        }
        return ConfigEditor.create(ctx, clazz, name);
    }

    public BaseConfigEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos, String msgs) {
        this._rsrcmgr = cfgmgr.getResourceManager();
        this._msgmgr = msgmgr;
        this._cfgmgr = cfgmgr;
        this._colorpos = colorpos;
        this._msgs = this._msgmgr.getBundle(msgs);
        ToolUtil.configureLog(String.valueOf(msgs) + ".log");
        this.setTitle(this._msgs.get("m.title"));
        this.setDefaultCloseOperation(2);
        this._eprefs = this.createEditablePrefs(_prefs);
        this._eprefs.init(this._rsrcmgr);
        boolean first = !cfgmgr.isInitialized();
        this.add((Component)new LogPanel(this._msgmgr, first), "South");
        if (first) {
            cfgmgr.init();
        }
    }

    @Override
    public ResourceManager getResourceManager() {
        return this._rsrcmgr;
    }

    @Override
    public MessageManager getMessageManager() {
        return this._msgmgr;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    @Override
    public ColorPository getColorPository() {
        return this._colorpos;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("close")) {
            this.dispose();
        } else if (action.equals("quit")) {
            System.exit(0);
        } else if (action.equals("preferences")) {
            if (this._pdialog == null) {
                this._pdialog = EditorPanel.createDialog(this, this, this._msgs.get("t.preferences"), this._eprefs);
            }
            this._pdialog.setVisible(true);
        } else if (action.equals("find")) {
            if (this._fdialog == null) {
                this._fdialog = FindDialog.createDialog(this, this);
            }
            this._fdialog.show(this.getFindEditorPanel());
        } else if (action.equals("find_next") && this._fdialog != null) {
            this._fdialog.find(this.getFindEditorPanel());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolUtil.windowAdded();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolUtil.windowRemoved();
    }

    protected ToolUtil.EditablePrefs createEditablePrefs(Preferences prefs) {
        return new ToolUtil.EditablePrefs(prefs);
    }

    protected JMenu createMenu(String name, int mnemonic) {
        return ToolUtil.createMenu(this._msgs, name, mnemonic);
    }

    protected JMenuItem createMenuItem(String action, int mnemonic, int accelerator) {
        return ToolUtil.createMenuItem(this, this._msgs, action, mnemonic, accelerator);
    }

    protected JMenuItem createMenuItem(String action, int mnemonic, int accelerator, int modifiers) {
        return ToolUtil.createMenuItem(this, this._msgs, action, mnemonic, accelerator, modifiers);
    }

    protected Action createAction(String command, int mnemonic, int accelerator) {
        return ToolUtil.createAction(this, this._msgs, command, mnemonic, accelerator);
    }

    protected Action createAction(String command, int mnemonic, int accelerator, int modifiers) {
        return ToolUtil.createAction(this, this._msgs, command, mnemonic, accelerator, modifiers);
    }

    protected JButton createButton(String action) {
        return ToolUtil.createButton(this, this._msgs, action);
    }

    protected JButton createButton(String action, String key) {
        return ToolUtil.createButton(this, this._msgs, action, key);
    }

    protected String getLabel(String name) {
        String key = "m." + name;
        return this._msgs.exists(key) ? this._msgs.get(key) : name;
    }

    protected String getLabel(Class<?> clazz, String type) {
        String key;
        MessageBundle msgs = this._msgmgr.getBundle(Introspector.getMessageBundle(clazz));
        return msgs.exists(key = "m." + type) ? msgs.get(key) : type;
    }

    protected void showFrame(JFrame frame) {
        frame.setLocation(this.getX() + 16, this.getY() + 16);
        frame.setVisible(true);
    }

    protected void addFindMenu(JMenu menu) {
        menu.addSeparator();
        this._find = this.createAction("find", 70, 70);
        menu.add(new JMenuItem(this._find));
        this._findNext = this.createAction("find_next", 78, 114, 0);
        menu.add(new JMenuItem(this._findNext));
    }

    protected BaseEditorPanel getFindEditorPanel() {
        return null;
    }
}

