/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.cache.CacheBuilder;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.ScopeUpdateListener;
import com.threerings.expr.Updater;
import com.threerings.util.DeepOmit;
import java.util.Map;

public class BoundConfig
extends ParameterizedConfig
implements ScopeUpdateListener {
    @Editable(weight=1.0)
    public ExpressionBinding[] bindings = ExpressionBinding.EMPTY_ARRAY;
    @DeepOmit
    protected transient Updater[] _updaters;
    @DeepOmit
    protected transient Map<Scope, BoundConfig> _bound;

    @Override
    public void scopeUpdated(ScopeEvent event) {
        this.wasUpdated();
    }

    @Override
    protected BoundConfig getBound(Scope scope) {
        BoundConfig bound;
        if (scope == null || this.bindings.length == 0) {
            return this;
        }
        if (this._bound == null) {
            this._bound = CacheBuilder.newBuilder().concurrencyLevel(1).softValues().weakKeys().initialCapacity(1).build().asMap();
        }
        if ((bound = this._bound.get(scope)) == null) {
            bound = (BoundConfig)this.clone();
            this._bound.put(scope, bound);
            bound.init(this._cfgmgr);
            bound._base = this;
            bound.bind(scope);
        }
        return bound;
    }

    @Override
    public void wasUpdated() {
        Object[] objectArray = this.bindings;
        int n = this.bindings.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionBinding binding = objectArray[n2];
            binding.invalidate();
            ++n2;
        }
        if (this._updaters != null) {
            objectArray = this._updaters;
            n = this._updaters.length;
            n2 = 0;
            while (n2 < n) {
                Object updater = objectArray[n2];
                updater.update();
                ++n2;
            }
        }
        super.wasUpdated();
        if (this._bound != null) {
            for (BoundConfig bound : this._bound.values()) {
                this.copy(bound);
                bound.wasUpdated();
            }
            if (this._bound.isEmpty()) {
                this._bound = null;
            }
        }
    }

    protected void bind(Scope scope) {
        this._updaters = new Updater[this.bindings.length];
        int ii = 0;
        while (ii < this.bindings.length) {
            this._updaters[ii] = this.bindings[ii].createUpdater(this._cfgmgr, scope, this);
            this._updaters[ii].update();
            ++ii;
        }
        scope.addListener(this);
    }
}

