/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import java.util.Arrays;

public class CoordIntArray {
    private Quaternion[][] quaters = null;
    private int _empty;

    public CoordIntArray(int size, int empty) {
        this.quaters = new Quaternion[size][size];
        this._empty = empty;
    }

    public int get(int x, int y) {
        int absX = Math.abs(x);
        int absY = Math.abs(y);
        if (this.quaters.length <= absY || this.quaters[0].length <= absX) {
            return this._empty;
        }
        Quaternion quater = this.quaters[absY][absX];
        if (quater == null) {
            return this._empty;
        }
        return quater.get(x, y);
    }

    public int put(int x, int y, int bits) {
        if (bits == this._empty) {
            return this.remove(x, y);
        }
        int absX = Math.abs(x);
        int absY = Math.abs(y);
        if (this.quaters.length <= absY || this.quaters[0].length <= absX) {
            this.quaters = CoordIntArray.expand(this.quaters, absX, absY);
        }
        if (this.quaters[absY][absX] == null) {
            this.quaters[absY][absX] = new Quaternion(x, y, bits);
            return this._empty;
        }
        return this.quaters[absY][absX].put(x, y, bits);
    }

    public int remove(int x, int y) {
        int absX = Math.abs(x);
        int absY = Math.abs(y);
        if (this.quaters.length <= absY || this.quaters[0].length <= absX) {
            return this._empty;
        }
        Quaternion quater = this.quaters[absY][absX];
        if (quater == null) {
            return this._empty;
        }
        return quater.remove(x, y);
    }

    public int setBits(int x, int y, int bits) {
        if (bits == 0) {
            return this.get(x, y);
        }
        int absX = Math.abs(x);
        int absY = Math.abs(y);
        if (this.quaters.length <= absY || this.quaters[0].length <= absX) {
            this.quaters = CoordIntArray.expand(this.quaters, absX, absY);
        }
        if (this.quaters[absY][absX] == null) {
            this.quaters[absY][absX] = new Quaternion(x, y, bits);
            return this._empty;
        }
        return this.quaters[absY][absX].set(x, y, bits);
    }

    public int size() {
        return this.quaters.length;
    }

    public void clear() {
        Quaternion[][] quaternionArray = this.quaters;
        int n = this.quaters.length;
        int n2 = 0;
        while (n2 < n) {
            Quaternion[] quater;
            Quaternion[] quaternionArray2 = quater = quaternionArray[n2];
            int n3 = quater.length;
            int n4 = 0;
            while (n4 < n3) {
                Quaternion q = quaternionArray2[n4];
                if (q != null) {
                    q.clear();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static Quaternion[][] expand(Quaternion[][] array, int minX, int minY) {
        int sizeY = array.length > minY ? array.length : Math.max(array.length * 2, minY + 1);
        int sizeX = array[0].length > minX ? array[0].length : Math.max(array[0].length * 2, minX + 1);
        Quaternion[][] newArrays = new Quaternion[sizeY][sizeX];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(array[i], 0, newArrays[i], 0, array[i].length);
            ++i;
        }
        return newArrays;
    }

    class Quaternion {
        int[] values = null;

        public Quaternion(int x, int y, int value) {
            this(x, y);
            Arrays.fill(this.values, coordIntArray._empty);
            this.values[this.getIndex((int)x, (int)y)] = value;
        }

        public Quaternion(int x, int y) {
            int size = 4;
            if (x == 0) {
                size -= 2;
            }
            if (y == 0) {
                size -= 2;
            }
            if (size == 0) {
                size = 1;
            }
            this.values = new int[size];
        }

        public int getIndex(int x, int y) {
            if (x == 0 && y == 0) {
                return 0;
            }
            if (x == 0) {
                return y > 0 ? 1 : 0;
            }
            if (y == 0) {
                return x > 0 ? 1 : 0;
            }
            if (x < 0) {
                if (y < 0) {
                    return 0;
                }
                return 1;
            }
            if (y < 0) {
                return 2;
            }
            return 3;
        }

        public int get(int x, int y) {
            return this.values[this.getIndex(x, y)];
        }

        public int put(int x, int y, int bits) {
            int index = this.getIndex(x, y);
            int value = this.values[index];
            this.values[index] = bits;
            return value;
        }

        public int remove(int x, int y) {
            int idx = this.getIndex(x, y);
            int ovalue = this.values[idx];
            if (ovalue != CoordIntArray.this._empty) {
                this.values[idx] = CoordIntArray.this._empty;
            }
            return ovalue;
        }

        public int set(int x, int y, int bits) {
            int index = this.getIndex(x, y);
            int value = this.values[index];
            int n = index;
            this.values[n] = this.values[n] | bits;
            return value;
        }

        public boolean isClear() {
            int[] nArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                int value = nArray[n2];
                if (value != CoordIntArray.this._empty) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void clear() {
            this.values = new int[this.values.length];
        }
    }
}

