/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.config.ConfigManager;
import com.threerings.editor.tools.AbstractValidatorTask;
import com.threerings.editor.util.Validator;
import com.threerings.export.BinaryImporter;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeySceneModel;
import java.io.File;
import java.io.FileInputStream;

public class SceneValidatorTask
extends AbstractValidatorTask {
    @Override
    protected boolean validate(ConfigManager cfgmgr, Iterable<File> files, Validator validator) {
        boolean valid = true;
        for (File source : files) {
            try {
                TudeySceneModel model = (TudeySceneModel)new BinaryImporter(new FileInputStream(source)).readObject();
                model.getConfigManager().init("scene", cfgmgr);
                validator.pushWhere("Scene: " + source);
                try {
                    valid &= model.validateReferences(validator);
                }
                finally {
                    validator.popWhere();
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to read scene.", new Object[]{"file", source, e});
            }
        }
        return valid;
    }
}

