/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.samskivert.util.ArrayUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.server.logic.Logic;

public class PathCandidate {
    protected boolean _unidirection = false;
    protected Logic _target;
    protected Vector2f[] _path;
    protected int _cidx;

    public PathCandidate(Logic target, Vector2f[] path, int cidx, boolean unidirection) {
        this._target = target;
        this._path = path;
        this._cidx = cidx;
        this._unidirection = unidirection;
    }

    public Logic getTarget() {
        return this._target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector2f[] getRemainingPath(float angle) {
        if (this._cidx == this._path.length - 1) {
            if (this._unidirection) return new Vector2f[]{this._path[this._path.length - 1]};
            ArrayUtil.reverse((Object[])this._path);
            return this._path;
        } else if (this._cidx != 0) {
            if (!this._unidirection) {
                Vector2f prev = this._path[this._cidx - 1];
                Vector2f node = this._path[this._cidx];
                Vector2f next = this._path[this._cidx + 1];
                float df = FloatMath.atan2(next.y - node.y, next.x - node.x);
                float dr = FloatMath.atan2(prev.y - node.y, prev.x - node.x);
                if (FloatMath.getAngularDistance(angle, dr) < FloatMath.getAngularDistance(angle, df)) {
                    this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)(this._cidx + 1));
                    ArrayUtil.reverse((Object[])this._path);
                    return this._path;
                } else {
                    this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)0, (int)(this._cidx + 1));
                }
                return this._path;
            } else {
                this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)0, (int)(this._cidx + 1));
            }
            return this._path;
        } else {
            this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)0, (int)1);
        }
        return this._path;
    }

    private boolean inRange(Vector2f trans, Vector2f start, Vector2f end) {
        return trans.x > start.x && trans.x < end.y;
    }
}

