/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.config.ConfigReference;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.BehaviorConfig;
import com.threerings.tudey.data.actor.Agent;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.logic.BehaviorLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import java.util.Map;

public class AgentLogic
extends PawnLogic {
    protected BehaviorLogic _behavior;
    protected float _targetRotation = Float.MAX_VALUE;
    protected float _turnRate;
    protected int _timestamp;

    public boolean canMove() {
        return this._advancer.canMove();
    }

    public boolean canRotate() {
        return this._advancer.canRotate();
    }

    public boolean canThink() {
        return this._behavior != null;
    }

    public Logic getBehaviorTarget() {
        return this._behavior == null ? null : this._behavior.getCurrentTarget();
    }

    public void face(Logic logic) {
        this.face(logic, false);
    }

    public void face(Logic logic, boolean force) {
        this.face(logic.getTranslation(), force);
    }

    public void face(Vector2f location, boolean force) {
        float rotation = this._actor.getTranslation().direction(location);
        if (force) {
            this._actor.setRotation(rotation);
            if (this._actor instanceof Mobile) {
                ((Mobile)this._actor).setDirection(rotation);
            }
            this.clearTargetRotation();
        } else {
            this.setTargetRotation(rotation);
        }
    }

    public void setTargetRotation(float rotation) {
        this._targetRotation = rotation;
        if (this._targetRotation == this._actor.getRotation()) {
            this.reachedTargetRotation();
        }
        System.out.println(this.getClass() + ",setTargetRotation=" + this._targetRotation);
    }

    public float getTargetRotation() {
        return this._targetRotation;
    }

    public void clearTargetRotation() {
        this._targetRotation = Float.MAX_VALUE;
        ((Agent)this._actor).setTurnDirection(0);
        System.out.println("clearTargetRotation=" + this._targetRotation);
    }

    public void setTurnRate(float rate) {
        if (rate > 0.0f) {
            this._turnRate = rate;
        } else {
            this.clearTurnRate();
        }
    }

    public void clearTurnRate() {
        this._turnRate = ((ActorConfig.Agent)this._config).turnRate;
    }

    public void setSpeed(float speed) {
        ((Agent)this._actor).setSpeed(speed);
    }

    public void modifySpeed(float modifier) {
        ((Agent)this._actor).setSpeed(((ActorConfig.Agent)this._config).speed * modifier);
    }

    public void clearSpeed() {
        ((Agent)this._actor).setSpeed(((ActorConfig.Agent)this._config).speed);
    }

    public float getSpeed() {
        return ((Agent)this._actor).getSpeed();
    }

    public void startMoving() {
        if (this.canMove()) {
            ((Mobile)this._actor).setDirection(this._actor.getRotation());
            this._actor.set(2);
        }
    }

    public void stopMoving() {
        this._actor.clear(2);
    }

    public BehaviorLogic createBehavior(ConfigReference<BehaviorConfig> ref) {
        BehaviorLogic logic;
        BehaviorConfig.Original original;
        BehaviorConfig config = this._scenemgr.getConfigManager().getConfig(BehaviorConfig.class, ref);
        BehaviorConfig.Original original2 = original = config == null ? null : config.getOriginal(this._scenemgr.getConfigManager());
        if (original == null) {
            original = new BehaviorConfig.Original();
        }
        if ((logic = (BehaviorLogic)this._scenemgr.createLogic(original.getLogicClassName())) == null) {
            return null;
        }
        logic.init(this._scenemgr, original, this);
        return logic;
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        AgentLogic asource = (AgentLogic)source;
        this._targetRotation = asource._targetRotation;
        this._turnRate = asource._turnRate;
        this._timestamp = asource._timestamp;
        if (this._behavior != null) {
            this._behavior.transfer(asource._behavior, refs);
        }
    }

    @Override
    public boolean tick(int timestamp) {
        super.tick(timestamp);
        if (this._behavior == null) {
            return true;
        }
        this._behavior.tick(timestamp);
        float elapsed = (float)(timestamp - this._timestamp) / 1000.0f;
        this._timestamp = timestamp;
        float rotation = this._actor.getRotation();
        if (this._targetRotation != Float.MAX_VALUE && rotation != this._targetRotation && this.canRotate()) {
            float diff = FloatMath.getAngularDifference(this._targetRotation, rotation);
            float angle = elapsed * this._turnRate;
            if (Math.abs(diff) - angle < 1.0E-6f) {
                this._actor.setRotation(this._targetRotation);
                this.reachedTargetRotation();
            } else {
                float dir = Math.signum(diff);
                ((Agent)this._actor).setTurnDirection((int)dir);
                this._actor.setRotation(FloatMath.normalizeAngle(rotation + angle * dir));
            }
        }
        return true;
    }

    @Override
    protected void wasDestroyed() {
        super.wasDestroyed();
        if (this._behavior != null) {
            this._behavior.shutdown();
        }
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._timestamp = this._actor.getCreated();
        this._behavior = this.createBehavior(((ActorConfig.Agent)this._config).behavior);
        this._behavior.startup();
        this.clearTurnRate();
        this.clearSpeed();
    }

    @Override
    protected void penetratedEnvironment(Vector2f penetration) {
        if (this._behavior != null) {
            this._behavior.penetratedEnvironment(penetration);
        }
    }

    protected void reachedTargetRotation() {
        ((Agent)this._actor).setTurnDirection(0);
        if (this._behavior != null) {
            this._behavior.reachedTargetRotation();
        }
    }

    public int getAttackMask(int idx) {
        return 0;
    }

    public BehaviorLogic getBehavior() {
        return this._behavior;
    }
}

