/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Wait.class, Move.class, Rotate.class, Condition.class, ConditionalScript.class, Goto.class, Action.class, SetSpeed.class, ClearSpeed.class})
public abstract class ScriptConfig
extends DeepObject
implements Exportable {
    public abstract String getLogicClassName();

    public void invalidate() {
    }

    public static class Action
    extends ScriptConfig {
        @Editable
        public ActionConfig action = new ActionConfig.SetVariable();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Action";
        }
    }

    public static class ClearSpeed
    extends ScriptConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$ClearSpeed";
        }
    }

    public static class Condition
    extends ScriptConfig {
        @Editable
        public ConditionConfig condition = new ConditionConfig.Always();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Condition";
        }
    }

    public static class ConditionalScript
    extends Condition {
        @Editable
        public ScriptConfig success = new Goto();
        @Editable
        public ScriptConfig failure = new Goto();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$ConditionalScript";
        }
    }

    public static class Goto
    extends ScriptConfig {
        @Editable(min=0.0)
        public int step = 0;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Goto";
        }
    }

    public static class Move
    extends ScriptConfig {
        @Editable(min=0.0)
        public int reload = 0;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Move";
        }
    }

    public static class Rotate
    extends ScriptConfig {
        @Editable(min=0.0, max=360.0, scale=0.017453292519943295, hgroup="d")
        public float direction = 0.0f;
        @Editable(min=0.0, max=360.0, scale=0.017453292519943295, hgroup="d")
        public float rotationVariance = 0.0f;
        @Editable
        public boolean relative;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Rotate";
        }
    }

    public static class SetSpeed
    extends ScriptConfig {
        @Editable(step=0.1, min=0.0)
        public float speed = 0.0f;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$SetSpeed";
        }
    }

    public static class Wait
    extends ScriptConfig {
        @Editable
        public int wait = 0;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ScriptLogic$Wait";
        }
    }
}

