/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.sprite.EffectSprite;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

@EditorTypes(value={Default.class, Animator.class})
public abstract class EffectSpriteConfig
extends DeepObject
implements Exportable,
Preloadable.LoadableConfig {
    @Editable(editor="mask", mode="floor", hgroup="a")
    public int floorMask = 1;
    @Editable(hgroup="a")
    public boolean attachToTarget;
    @Editable
    public boolean rotateWithTarget = true;
    @Editable(nullable=true)
    public ConfigReference<ModelConfig> model;

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
        preloads.add(new Preloadable.Model(this.model));
    }

    @Override
    public void preload(GlContext ctx) {
        if (this.model != null) {
            ModelConfig config = this.model.getConfig(ctx.getConfigManager(), ModelConfig.class);
            config.preload(ctx);
        }
    }

    public abstract EffectSprite.Implementation createImplementation(TudeyContext var1, Scope var2, Effect var3);

    public static class Animator
    extends EffectSpriteConfig {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;

        @Override
        public EffectSprite.Implementation createImplementation(TudeyContext ctx, Scope scope, Effect effect) {
            return new EffectSprite.Animator(ctx, scope, this, effect);
        }

        @Override
        public void preload(GlContext ctx) {
            super.preload(ctx);
            if (this.animation != null) {
                AnimationConfig config = this.animation.getConfig(ctx.getConfigManager(), AnimationConfig.class);
                config.preload(ctx);
            }
        }
    }

    public static class Default
    extends EffectSpriteConfig {
        @Override
        public EffectSprite.Implementation createImplementation(TudeyContext ctx, Scope scope, Effect effect) {
            return new EffectSprite.Original(ctx, scope, this, effect);
        }
    }
}

