/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing.filetree;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;

public class ChainFileFilter
implements FileFilter {
    private Set<FileFilter> filters = Sets.newHashSet();

    public ChainFileFilter(FileFilter ... filters) {
        FileFilter[] fileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            if (filter != null) {
                this.filters.add(filter);
            }
            ++n2;
        }
    }

    @Override
    public boolean accept(File pathname) {
        if (this.filters != null) {
            for (FileFilter filter : this.filters) {
                if (filter == null || filter.accept(pathname)) continue;
                return false;
            }
        }
        return true;
    }

    public void add(FileFilter filter) {
        this.filters.add(filter);
    }
}

