/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.background;

import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Renderer;

public class ImageBackground
extends Background {
    public static final int CENTER_XY = 0;
    public static final int CENTER_X = 1;
    public static final int CENTER_Y = 2;
    public static final int SCALE_XY = 3;
    public static final int SCALE_X = 4;
    public static final int SCALE_Y = 5;
    public static final int TILE_XY = 6;
    public static final int TILE_X = 7;
    public static final int TILE_Y = 8;
    public static final int FRAME_XY = 9;
    public static final int FRAME_X = 10;
    public static final int FRAME_Y = 11;
    public static final int ASPECT_INNER = 12;
    public static final int ASPECT_OUTER = 13;
    public static final int ANCHOR_LL = 0;
    public static final int ANCHOR_LR = 1;
    public static final int ANCHOR_UR = 2;
    public static final int ANCHOR_UL = 3;
    protected int _mode;
    protected int _anchor;
    protected Image _image;
    protected Insets _frame;
    protected static final int CENTER = 0;
    protected static final int SCALE = 1;
    protected static final int TILE = 2;
    protected static final int FRAME = 3;
    protected static final int ASPECT = 4;

    public ImageBackground(int mode, Image image) {
        this(mode, image, null);
    }

    public ImageBackground(int mode, Image image, Insets frame) {
        this(mode, image, frame, 0);
    }

    public ImageBackground(int mode, Image image, Insets frame, int anchor) {
        this._mode = mode;
        this._image = image;
        this._frame = frame;
        this._anchor = anchor;
        if (this._frame == null && (this._mode == 10 || this._mode == 11 || this._mode == 9)) {
            int twidth = this._image.getWidth();
            int theight = this._image.getHeight();
            this._frame = new Insets();
            this._frame.left = twidth / 3;
            this._frame.right = twidth / 3;
            this._frame.top = theight / 3;
            this._frame.bottom = theight / 3;
        }
    }

    @Override
    public int getMinimumWidth() {
        return this._mode == 7 || this._mode == 6 ? 0 : (this._mode == 9 || this._mode == 10 ? this._frame.left + this._frame.right : this._image.getWidth());
    }

    @Override
    public int getMinimumHeight() {
        return this._mode == 8 || this._mode == 6 ? 0 : (this._mode == 9 || this._mode == 11 ? this._frame.top + this._frame.bottom : this._image.getHeight());
    }

    @Override
    public void render(Renderer renderer, int x, int y, int width, int height, float alpha) {
        super.render(renderer, x, y, width, height, alpha);
        switch (this._mode / 3) {
            case 0: {
                this.renderCentered(renderer, x, y, width, height, alpha);
                break;
            }
            case 1: {
                this.renderScaled(renderer, x, y, width, height, alpha);
                break;
            }
            case 2: {
                this.renderTiled(renderer, x, y, width, height, alpha);
                break;
            }
            case 3: {
                this.renderFramed(renderer, x, y, width, height, alpha);
                break;
            }
            case 4: {
                this.renderAspectScaled(renderer, x, y, width, height, alpha);
            }
        }
    }

    protected void renderCentered(Renderer renderer, int x, int y, int width, int height, float alpha) {
        if (this._mode == 1 || this._mode == 0) {
            x += (width - this._image.getWidth()) / 2;
        }
        if (this._mode == 2 || this._mode == 0) {
            y += (height - this._image.getHeight()) / 2;
        }
        this._image.render(renderer, x, y, alpha);
    }

    protected void renderScaled(Renderer renderer, int x, int y, int width, int height, float alpha) {
        switch (this._mode) {
            case 4: {
                y = (height - this._image.getHeight()) / 2;
                height = this._image.getHeight();
                break;
            }
            case 5: {
                x = (width - this._image.getWidth()) / 2;
                width = this._image.getWidth();
            }
        }
        this._image.render(renderer, x, y, width, height, alpha);
    }

    protected void renderTiled(Renderer renderer, int x, int y, int width, int height, float alpha) {
        int iwidth = this._image.getWidth();
        int iheight = this._image.getHeight();
        if (this._mode == 7) {
            this.renderRow(renderer, x, y, width, Math.min(height, iheight), 0, alpha);
        } else if (this._mode == 8) {
            int up = height / iheight;
            iwidth = Math.min(width, iwidth);
            int remain = height % iheight;
            int offset = 0;
            if (remain > 0 && (this._anchor == 3 || this._anchor == 2)) {
                this._image.render(renderer, 0, iheight - remain, iwidth, remain, x, y, iwidth, remain, alpha);
                offset = remain;
            }
            int yy = 0;
            while (yy < up) {
                this._image.render(renderer, 0, 0, iwidth, iheight, x, offset + y + yy * iheight, iwidth, iheight, alpha);
                ++yy;
            }
            if (remain > 0 && (this._anchor == 0 || this._anchor == 1)) {
                this._image.render(renderer, 0, 0, iwidth, remain, x, y + up * iheight, iwidth, remain, alpha);
            }
        } else if (this._mode == 6) {
            int up = height / iheight;
            int remain = height % iheight;
            int offset = 0;
            if (remain > 0 && (this._anchor == 3 || this._anchor == 2)) {
                this.renderRow(renderer, x, y, width, remain, iheight - remain, alpha);
                offset = remain;
            }
            int yy = 0;
            while (yy < up) {
                this.renderRow(renderer, x, offset + y + yy * iheight, width, iheight, 0, alpha);
                ++yy;
            }
            if (remain > 0 && (this._anchor == 0 || this._anchor == 1)) {
                this.renderRow(renderer, x, y + up * iheight, width, remain, 0, alpha);
            }
        }
    }

    protected void renderRow(Renderer renderer, int x, int y, int width, int iheight, int sy, float alpha) {
        int iwidth = this._image.getWidth();
        int across = width / iwidth;
        int remain = width % iwidth;
        int offset = 0;
        if (remain > 0 && (this._anchor == 1 || this._anchor == 2)) {
            this._image.render(renderer, iwidth - remain, sy, remain, iheight, x, y, remain, iheight, alpha);
            offset = remain;
        }
        int xx = 0;
        while (xx < across) {
            this._image.render(renderer, 0, sy, iwidth, iheight, offset + x + xx * iwidth, y, iwidth, iheight, alpha);
            ++xx;
        }
        if (remain > 0 && (this._anchor == 0 || this._anchor == 3)) {
            this._image.render(renderer, 0, sy, remain, iheight, x + across * iwidth, y, remain, iheight, alpha);
        }
    }

    protected void renderFramed(Renderer renderer, int x, int y, int width, int height, float alpha) {
        int twidth = this._image.getWidth();
        int theight = this._image.getHeight();
        this._image.render(renderer, 0, 0, this._frame.left, this._frame.bottom, x, y, alpha);
        this._image.render(renderer, twidth - this._frame.right, 0, this._frame.right, this._frame.bottom, x + width - this._frame.right, y, alpha);
        this._image.render(renderer, 0, theight - this._frame.top, this._frame.left, this._frame.top, x, y + height - this._frame.top, alpha);
        this._image.render(renderer, twidth - this._frame.right, theight - this._frame.top, this._frame.right, this._frame.top, x + width - this._frame.right, y + height - this._frame.top, alpha);
        int wmiddle = twidth - this._frame.getHorizontal();
        int hmiddle = theight - this._frame.getVertical();
        int gwmiddle = width - this._frame.getHorizontal();
        int ghmiddle = height - this._frame.getVertical();
        this._image.render(renderer, this._frame.left, 0, wmiddle, this._frame.bottom, x + this._frame.left, y, gwmiddle, this._frame.bottom, alpha);
        this._image.render(renderer, this._frame.left, theight - this._frame.top, wmiddle, this._frame.top, x + this._frame.left, y + height - this._frame.top, gwmiddle, this._frame.top, alpha);
        this._image.render(renderer, 0, this._frame.bottom, this._frame.left, hmiddle, x, y + this._frame.bottom, this._frame.left, ghmiddle, alpha);
        this._image.render(renderer, twidth - this._frame.right, this._frame.bottom, this._frame.right, hmiddle, x + width - this._frame.right, y + this._frame.bottom, this._frame.right, ghmiddle, alpha);
        this._image.render(renderer, this._frame.left, this._frame.bottom, wmiddle, hmiddle, x + this._frame.left, y + this._frame.bottom, gwmiddle, ghmiddle, alpha);
    }

    protected void renderAspectScaled(Renderer renderer, int x, int y, int width, int height, float alpha) {
        int sx = 0;
        int sy = 0;
        int swidth = this._image.getWidth();
        int sheight = this._image.getHeight();
        float x_aspect = (float)width / (float)swidth;
        float y_aspect = (float)height / (float)sheight;
        if (this._mode == 12) {
            if (x_aspect > y_aspect) {
                sheight = height * swidth / width;
                sy = (this._image.getHeight() - sheight) / 2;
            } else if (y_aspect > x_aspect) {
                swidth = width * sheight / height;
                sx = (this._image.getWidth() - swidth) / 2;
            }
        } else if (x_aspect < y_aspect) {
            int nheight = (int)((float)sheight * x_aspect);
            y = (height - nheight) / 2;
            height = nheight;
        } else if (y_aspect < x_aspect) {
            int nwidth = (int)((float)swidth * y_aspect);
            x = (width - nwidth) / 2;
            width = nwidth;
        }
        this._image.render(renderer, sx, sy, swidth, sheight, x, y, width, height, alpha);
    }
}

