/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.samskivert.util.Interval;
import com.samskivert.util.RunQueue;
import com.threerings.config.Reference;
import com.threerings.config.tools.ConfigEditor;
import com.threerings.config.tools.ResourceEditor;
import com.threerings.editor.Editable;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.math.Vector3f;
import com.threerings.opengl.GlCanvas;
import com.threerings.opengl.GlCanvasApp;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.camera.MouseOrbiter;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.Compass;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Grid;
import com.threerings.opengl.util.Stats;
import com.threerings.swing.LogPanel;
import com.threerings.util.MessageBundle;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class GlCanvasTool
extends GlCanvasApp
implements EditorContext,
ActionListener {
    protected MessageBundle _msgs;
    protected CanvasToolPrefs _eprefs;
    protected JCheckBoxMenuItem _showBounds;
    protected JCheckBoxMenuItem _showCompass;
    protected JCheckBoxMenuItem _showGrid;
    protected JCheckBoxMenuItem _showStats;
    protected JDialog _pdialog;
    protected Grid _grid;
    protected DebugBounds _bounds;
    protected Compass _compass;
    protected Stats _stats;

    public GlCanvasTool(String msgs) {
        ToolUtil.configureLog(String.valueOf(msgs) + ".log");
        this._msgs = this._msgmgr.getBundle(msgs);
        this._eprefs = this.createEditablePrefs();
        this._eprefs.init(this._rsrcmgr);
        this._frame.add((Component)new LogPanel(this._msgmgr, true), "South");
        if (!this._cfgmgr.isInitialized()) {
            this._cfgmgr.init();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("quit")) {
            this.shutdown();
        } else if (action.equals("configs")) {
            new ConfigEditor(this._msgmgr, this._cfgmgr, this._colorpos).setVisible(true);
        } else if (action.equals("resources")) {
            new ResourceEditor(this._msgmgr, this._cfgmgr, this._colorpos).setVisible(true);
        } else if (action.equals("preferences")) {
            if (this._pdialog == null) {
                this._pdialog = EditorPanel.createDialog(this._canvas, this, this._msgs.get("t.preferences"), this._eprefs);
            }
            this._pdialog.setVisible(true);
        } else if (action.equals("refresh")) {
            this._rsrcmgr.checkForModifications();
        } else if (action.equals("recenter")) {
            ((OrbitCameraHandler)this._camhand).getTarget().set(Vector3f.ZERO);
        }
    }

    @Override
    public boolean shouldCheckTimestamps() {
        return true;
    }

    @Override
    protected CameraHandler createCameraHandler() {
        OrbitCameraHandler camhand = new OrbitCameraHandler(this);
        new MouseOrbiter(camhand).addTo(this._canvas);
        return camhand;
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._eprefs.didInit();
        this._grid = this.createGrid();
        this._grid.getColor().set(0.2f, 0.2f, 0.2f, 1.0f);
        this._bounds = this.createBounds();
        this._compass = new Compass(this);
        this._stats = new Stats(this);
    }

    @Override
    protected void compositeView() {
        super.compositeView();
        if (this._showGrid != null && this._showGrid.isSelected()) {
            this._grid.composite();
        }
        if (this._bounds != null && this._showBounds.isSelected()) {
            this._bounds.composite();
        }
        if (this._showCompass != null && this._showCompass.isSelected()) {
            this._compass.composite();
        }
        if (this._showStats.isSelected()) {
            this._stats.composite();
        }
    }

    protected abstract CanvasToolPrefs createEditablePrefs();

    protected Grid createGrid() {
        return new Grid((GlContext)this, 65, 1.0f);
    }

    protected DebugBounds createBounds() {
        return null;
    }

    protected JMenu createMenu(String name, int mnemonic) {
        return ToolUtil.createMenu(this._msgs, name, mnemonic);
    }

    protected JMenuItem createMenuItem(String action, int mnemonic, int accelerator) {
        return ToolUtil.createMenuItem(this, this._msgs, action, mnemonic, accelerator);
    }

    protected JMenuItem createMenuItem(String action, int mnemonic, int accelerator, int modifiers) {
        return ToolUtil.createMenuItem(this, this._msgs, action, mnemonic, accelerator, modifiers);
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String action, int mnemonic, int accelerator) {
        return ToolUtil.createCheckBoxMenuItem(this, this._msgs, action, mnemonic, accelerator);
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String action, int mnemonic, int accelerator, int modifiers) {
        return ToolUtil.createCheckBoxMenuItem(this, this._msgs, action, mnemonic, accelerator, modifiers);
    }

    protected Action createAction(String command, int mnemonic, int accelerator) {
        return ToolUtil.createAction(this, this._msgs, command, mnemonic, accelerator);
    }

    protected Action createAction(String command, int mnemonic, int accelerator, int modifiers) {
        return ToolUtil.createAction(this, this._msgs, command, mnemonic, accelerator, modifiers);
    }

    protected JButton createButton(String action) {
        return ToolUtil.createButton(this, this._msgs, action);
    }

    protected JButton createButton(String action, String key) {
        return ToolUtil.createButton(this, this._msgs, action, key);
    }

    protected class CanvasToolPrefs
    extends ToolUtil.EditablePrefs {
        protected Interval _refreshInterval;

        public CanvasToolPrefs(Preferences prefs) {
            super(prefs);
            this._refreshInterval = new Interval(RunQueue.AWT){

                public void expired() {
                    CanvasToolPrefs.this._rsrcmgr.checkForModifications();
                }
            };
            this.rescheduleRefreshInterval();
            Color4f color = this.getPref("background_color", Color4f.GRAY);
            GlCanvasTool.this._compositor.getDefaultBackgroundColor().set(color.r, color.g, color.b, 0.0f);
            GlCanvasTool.this._renderScheme = this._prefs.get("render_scheme", null);
            GlCanvasTool.this._compatibilityMode = this._prefs.getBoolean("compatibility_mode", false);
            GlCanvasTool.this._renderEffects = this._prefs.getBoolean("render_effects", true);
        }

        public void didInit() {
            ((GlCanvas)((Object)GlCanvasTool.this._canvas)).setVSyncEnabled(this.getVSyncEnabled());
        }

        @Editable(weight=1.0)
        public void setAutoRefreshEnabled(boolean enabled) {
            this._prefs.putBoolean("auto_refresh_enabled", enabled);
            this.rescheduleRefreshInterval();
        }

        @Editable
        public boolean isAutoRefreshEnabled() {
            return this._prefs.getBoolean("auto_refresh_enabled", false);
        }

        @Editable(weight=2.0, min=0.0, step=0.01)
        public void setRefreshInterval(float interval) {
            this._prefs.putFloat("refresh_interval", interval);
            this.rescheduleRefreshInterval();
        }

        @Editable
        public float getRefreshInterval() {
            return this._prefs.getFloat("refresh_interval", 0.5f);
        }

        @Editable(weight=3.0)
        public void setBackgroundColor(Color4f color) {
            GlCanvasTool.this._compositor.getDefaultBackgroundColor().set(color.r, color.g, color.b, 0.0f);
            this.putPref("background_color", color);
        }

        @Editable
        public Color4f getBackgroundColor() {
            Color4f color = GlCanvasTool.this._compositor.getDefaultBackgroundColor();
            return new Color4f(color.r, color.g, color.b, 1.0f);
        }

        @Editable(weight=4.0)
        public void setVSyncEnabled(boolean enabled) {
            ((GlCanvas)((Object)GlCanvasTool.this._canvas)).setVSyncEnabled(enabled);
            this._prefs.putBoolean("vsync_enabled", enabled);
        }

        @Editable
        public boolean getVSyncEnabled() {
            return this._prefs.getBoolean("vsync_enabled", true);
        }

        @Editable(nullable=true, weight=5.0)
        @Reference(value=RenderSchemeConfig.class)
        public void setRenderScheme(String scheme) {
            GlCanvasTool.this.setRenderScheme(scheme);
            if (scheme == null) {
                this._prefs.remove("render_scheme");
            } else {
                this._prefs.put("render_scheme", scheme);
            }
        }

        @Editable
        @Reference(value=RenderSchemeConfig.class)
        public String getRenderScheme() {
            return GlCanvasTool.this._renderScheme;
        }

        @Editable(weight=6.0)
        public void setCompatibilityMode(boolean enabled) {
            GlCanvasTool.this.setCompatibilityMode(enabled);
            this._prefs.putBoolean("compatibility_mode", enabled);
        }

        @Editable
        public boolean getCompatibilityMode() {
            return GlCanvasTool.this._compatibilityMode;
        }

        @Editable(weight=7.0)
        public void setRenderEffects(boolean enabled) {
            GlCanvasTool.this.setRenderEffects(enabled);
            this._prefs.putBoolean("render_effects", enabled);
        }

        @Editable
        public boolean getRenderEffects() {
            return GlCanvasTool.this._renderEffects;
        }

        protected void rescheduleRefreshInterval() {
            float interval = this.getRefreshInterval();
            if (this.isAutoRefreshEnabled() && interval > 0.0f) {
                this._refreshInterval.schedule((long)(interval * 1000.0f), true);
            } else {
                this._refreshInterval.cancel();
            }
        }
    }
}

