/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.threerings.ClydeLog;
import com.threerings.openal.ClipBuffer;
import com.threerings.openal.Sound;
import com.threerings.openal.util.AlContext;
import java.util.ArrayList;

public class SoundClipManager {
    protected AlContext _ctx;
    protected ArrayList<SoundEntry> _sounds = Lists.newArrayList();
    protected Multiset<String> _counts = HashMultiset.create();
    protected static final float[] GAIN_LEVEL = new float[]{1.0f, 1.5f, 2.0f, 2.4f};
    protected static final float MIN_GAP = 0.05f;
    protected static final float MIN_STOP = 0.15f;

    public SoundClipManager(AlContext ctx) {
        this._ctx = ctx;
    }

    public void playSound(Sound sound, final float gain) {
        int ii;
        ClipBuffer buffer = sound.getBuffer();
        if (buffer == null) {
            return;
        }
        final String path = buffer.getPath();
        int count = this._counts.count((Object)path);
        boolean canStop = false;
        if (sound.isPlaying() || count > 0) {
            ii = this._sounds.size() - 1;
            while (ii >= 0) {
                SoundEntry entry = this._sounds.get(ii);
                if (sound.isPlaying()) {
                    if (entry.sound == sound) {
                        this._sounds.remove(ii);
                        this._counts.remove((Object)path);
                        --count;
                        ClydeLog.log.debug((Object)"ClipManager replaying sound", new Object[]{"path", path});
                        break;
                    }
                } else {
                    if (entry.elapsed < 0.05f && entry.sound.getBuffer().getPath().equals(path)) {
                        ClydeLog.log.debug((Object)"ClipManager prevent same sound", new Object[]{"path", path});
                        return;
                    }
                    if (!canStop && entry.elapsed > 0.15f && entry.sound.getBuffer().getPath().equals(path)) {
                        canStop = true;
                    }
                }
                --ii;
            }
        }
        if (count + 1 >= GAIN_LEVEL.length) {
            if (!canStop) {
                ClydeLog.log.debug((Object)"ClipManager prevent sound no popped", new Object[]{"path", path});
                return;
            }
            ii = 0;
            int nn = this._sounds.size();
            while (ii < nn) {
                SoundEntry entry = this._sounds.get(ii);
                if (entry.sound.getBuffer().getPath().equals(sound.getBuffer().getPath())) {
                    this._sounds.remove(ii);
                    this._counts.remove((Object)entry.sound.getBuffer().getPath());
                    ClydeLog.log.debug((Object)"ClipManager sound popped", new Object[]{"path", path});
                    break;
                }
                ++ii;
            }
        }
        this._counts.add((Object)path);
        sound.play(true, false, new Sound.StartObserver(){

            public void soundStarted(Sound sound) {
                if (sound == null) {
                    SoundClipManager.this._counts.remove((Object)path);
                    ClydeLog.log.debug((Object)"Failed to start sound", new Object[]{"path", path});
                    return;
                }
                SoundClipManager.this._sounds.add(new SoundEntry(sound, gain));
                int count = SoundClipManager.this._counts.count((Object)path);
                sound.setGain(gain * SoundClipManager.this.getGainModifier(count));
                ClydeLog.log.debug((Object)"ClipManager play sound", new Object[]{"count", count, "path", path});
            }
        });
    }

    public void tick(float elapsed) {
        int ii = this._sounds.size() - 1;
        while (ii >= 0) {
            SoundEntry entry = this._sounds.get(ii);
            if (!entry.sound.isPlaying()) {
                this._sounds.remove(ii);
                this._counts.remove((Object)entry.sound.getBuffer().getPath());
                ClydeLog.log.debug((Object)"ClipManager sound ended", new Object[]{"path", entry.sound.getBuffer().getPath()});
            } else {
                entry.elapsed += elapsed;
                int count = this._counts.count((Object)entry.sound.getBuffer().getPath());
                entry.sound.setGain(entry.gain * this.getGainModifier(count));
            }
            --ii;
        }
    }

    protected float getGainModifier(int count) {
        return this._ctx.getSoundManager().getBaseGain() * GAIN_LEVEL[count - 1] / (float)count;
    }

    protected class SoundEntry {
        public Sound sound;
        public float gain;
        public float elapsed;

        public SoundEntry(Sound sound, float gain) {
            this.sound = sound;
            this.gain = gain;
        }
    }
}

