/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix3f;
import com.threerings.math.Matrix4f;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import java.io.IOException;

public final class Transform2D
implements Exportable,
Streamable {
    public static final int IDENTITY = 0;
    public static final int RIGID = 1;
    public static final int UNIFORM = 2;
    public static final int AFFINE = 3;
    public static final int GENERAL = 4;
    protected int _type;
    protected Vector2f _translation;
    protected float _rotation;
    protected float _scale = 1.0f;
    protected Matrix3f _matrix;

    public Transform2D() {
    }

    public Transform2D(int type) {
        this.setType(type);
    }

    public Transform2D(Vector2f translation, float rotation) {
        this.set(translation, rotation);
    }

    public Transform2D(Vector2f translation, float rotation, float scale) {
        this.set(translation, rotation, scale);
    }

    public Transform2D(Vector2f translation, float rotation, Vector2f scale) {
        this.set(translation, rotation, scale);
    }

    public Transform2D(Matrix3f matrix) {
        this.set(matrix);
    }

    public Transform2D(Matrix3f matrix, boolean affine) {
        this.set(matrix, affine);
    }

    public Transform2D(Transform3D transform) {
        this.set(transform);
    }

    public Transform2D(Transform2D transform) {
        this.set(transform);
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
        if ((this._type == 3 || this._type == 4) && this._matrix == null) {
            this._matrix = new Matrix3f();
        } else if ((this._type == 1 || this._type == 2) && this._translation == null) {
            this._translation = new Vector2f();
        }
    }

    public Vector2f getTranslation() {
        return this._translation;
    }

    public float getRotation() {
        return this._rotation;
    }

    public float setRotation(float rotation) {
        this._rotation = rotation;
        return this._rotation;
    }

    public float getScale() {
        return this._scale;
    }

    public float setScale(float scale) {
        this._scale = scale;
        return this._scale;
    }

    public Matrix3f getMatrix() {
        return this._matrix;
    }

    public Transform2D invertLocal() {
        return this.invert(this);
    }

    public Transform2D invert() {
        return this.invert(new Transform2D());
    }

    public Transform2D invert(Transform2D result) {
        switch (this._type) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                this._translation.negate(result.getTranslation()).rotateLocal(result.setRotation(-this._rotation));
                return result;
            }
            case 2: {
                result.setType(2);
                this._translation.negate(result.getTranslation()).rotateLocal(result.setRotation(-this._rotation)).multLocal(result.setScale(1.0f / this._scale));
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.invertAffine(result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.invert(result.getMatrix());
        return result;
    }

    public Transform2D composeLocal(Transform2D other) {
        return this.compose(other, this);
    }

    public Transform2D compose(Transform2D other) {
        return this.compose(other, new Transform2D());
    }

    public Transform2D compose(Transform2D other, Transform2D result) {
        int ctype = Math.max(this.getType(), other.getType());
        this.update(ctype);
        other.update(ctype);
        switch (ctype) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                other.getTranslation().rotateAndAdd(this._rotation, this._translation, result.getTranslation());
                result.setRotation(FloatMath.normalizeAngle(this._rotation + other.getRotation()));
                return result;
            }
            case 2: {
                result.setType(2);
                other.getTranslation().rotateScaleAndAdd(this._rotation, this._scale, this._translation, result.getTranslation());
                result.setRotation(FloatMath.normalizeAngle(this._rotation + other.getRotation()));
                result.setScale(this._scale * other.getScale());
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.multAffine(other.getMatrix(), result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.mult(other.getMatrix(), result.getMatrix());
        return result;
    }

    public Transform2D lerpLocal(Transform2D other, float t) {
        return this.lerp(other, t, this);
    }

    public Transform2D lerp(Transform2D other, float t) {
        return this.lerp(other, t, new Transform2D());
    }

    public Transform2D lerp(Transform2D other, float t, Transform2D result) {
        int ctype = Math.max(this.getType(), other.getType());
        this.update(ctype);
        other.update(ctype);
        switch (ctype) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                this._translation.lerp(other.getTranslation(), t, result.getTranslation());
                result.setRotation(FloatMath.lerpa(this._rotation, other.getRotation(), t));
                return result;
            }
            case 2: {
                result.setType(2);
                this._translation.lerp(other.getTranslation(), t, result.getTranslation());
                result.setRotation(FloatMath.lerpa(this._rotation, other.getRotation(), t));
                result.setScale(FloatMath.lerp(this._scale, other.getScale(), t));
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.lerpAffine(other.getMatrix(), t, result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.lerp(other.getMatrix(), t, result.getMatrix());
        return result;
    }

    public Transform2D set(Transform2D transform) {
        switch (transform.getType()) {
            default: {
                return this.setToIdentity();
            }
            case 1: {
                return this.set(transform.getTranslation(), transform.getRotation());
            }
            case 2: {
                return this.set(transform.getTranslation(), transform.getRotation(), transform.getScale());
            }
            case 3: {
                return this.set(transform.getMatrix(), true);
            }
            case 4: 
        }
        return this.set(transform.getMatrix(), false);
    }

    public Transform2D set(Transform3D transform) {
        int type = transform.getType();
        switch (type) {
            default: {
                return this.setToIdentity();
            }
            case 1: 
            case 2: {
                this.setType(type);
                Vector3f translation = transform.getTranslation();
                this._translation.set(translation.x, translation.y);
                this._rotation = transform.getRotation().getRotationZ();
                if (type == 2) {
                    this._scale = transform.getScale();
                }
                return this;
            }
            case 3: 
            case 4: 
        }
        this.setType(type);
        Matrix4f matrix = transform.getMatrix();
        this._matrix.set(matrix.m00, matrix.m10, matrix.m30, matrix.m01, matrix.m11, matrix.m31, matrix.m03, matrix.m13, matrix.m33);
        return this;
    }

    public Transform2D setToIdentity() {
        this.setType(0);
        return this;
    }

    public Transform2D set(Vector2f translation, float rotation) {
        this.setType(1);
        this._translation.set(translation);
        this._rotation = rotation;
        return this;
    }

    public Transform2D set(Vector2f translation, float rotation, float scale) {
        this.setType(2);
        this._translation.set(translation);
        this._rotation = rotation;
        this._scale = scale;
        return this;
    }

    public Transform2D set(Vector2f translation, float rotation, Vector2f scale) {
        this.setType(3);
        this._matrix.setToTransform(translation, rotation, scale);
        return this;
    }

    public Transform2D set(Matrix3f matrix) {
        return this.set(matrix, false);
    }

    public Transform2D set(Matrix3f matrix, boolean affine) {
        this.setType(affine ? 3 : 4);
        this._matrix.set(matrix);
        return this;
    }

    public Transform2D promote(int type) {
        this.update(type);
        this.setType(type);
        return this;
    }

    public Transform2D update(int utype) {
        if (this._type == 0) {
            if (utype >= 3) {
                this._matrix = this._matrix == null ? new Matrix3f() : this._matrix;
            } else if (utype >= 1) {
                this._translation = this._translation == null ? new Vector2f() : this._translation;
                this._rotation = 0.0f;
                this._scale = 1.0f;
            }
        } else if (this._type == 1) {
            if (utype >= 3) {
                (this._matrix == null ? (this._matrix = new Matrix3f()) : this._matrix).setToTransform(this._translation, this._rotation);
            } else if (utype == 2) {
                this._scale = 1.0f;
            }
        } else if (this._type == 2 && utype >= 3) {
            (this._matrix == null ? (this._matrix = new Matrix3f()) : this._matrix).setToTransform(this._translation, this._rotation, this._scale);
        }
        return this;
    }

    public Vector2f transformPointLocal(Vector2f pt) {
        return this.transformPoint(pt, pt);
    }

    public Vector2f transformPoint(Vector2f pt) {
        return this.transformPoint(pt, new Vector2f());
    }

    public Vector2f transformPoint(Vector2f pt, Vector2f result) {
        switch (this._type) {
            default: {
                return result.set(pt);
            }
            case 1: {
                return pt.rotate(this._rotation, result).addLocal(this._translation);
            }
            case 2: {
                return pt.mult(this._scale, result).rotateLocal(this._rotation).addLocal(this._translation);
            }
            case 3: 
            case 4: 
        }
        return this._matrix.transformPoint(pt, result);
    }

    public Vector2f transformVectorLocal(Vector2f vec) {
        return this.transformVector(vec, vec);
    }

    public Vector2f transformVector(Vector2f vec) {
        return this.transformVector(vec, new Vector2f());
    }

    public Vector2f transformVector(Vector2f vec, Vector2f result) {
        switch (this._type) {
            default: {
                return result.set(vec);
            }
            case 1: {
                return vec.rotate(this._rotation, result);
            }
            case 2: {
                return vec.mult(this._scale, result).rotateLocal(this._rotation);
            }
            case 3: 
            case 4: 
        }
        return this._matrix.transformVector(vec, result);
    }

    public Vector2f extractTranslation() {
        return this.extractTranslation(new Vector2f());
    }

    public Vector2f extractTranslation(Vector2f result) {
        switch (this._type) {
            default: {
                return result.set(Vector2f.ZERO);
            }
            case 1: 
            case 2: {
                return result.set(this._translation);
            }
            case 3: 
            case 4: 
        }
        return result.set(this._matrix.m20, this._matrix.m21);
    }

    public float extractRotation() {
        switch (this._type) {
            default: {
                return 0.0f;
            }
            case 1: 
            case 2: {
                return this._rotation;
            }
            case 3: 
            case 4: 
        }
        return this._matrix.extractRotation();
    }

    public float approximateUniformScale() {
        switch (this._type) {
            default: {
                return 1.0f;
            }
            case 2: {
                return this._scale;
            }
            case 3: 
            case 4: 
        }
        return this._matrix.approximateUniformScale();
    }

    public void writeFields(Exporter out) throws IOException {
        if (this._type == 0) {
            return;
        }
        if (this._type == 3 || this._type == 4) {
            out.write("matrix", this._matrix, Matrix3f.IDENTITY);
        } else {
            if (this._type == 2) {
                out.write("scale", this._scale, 1.0f);
            }
            out.write("translation", this._translation, Vector2f.ZERO);
            out.write("rotation", this._rotation, 0.0f);
        }
    }

    public void readFields(Importer in) throws IOException {
        this._translation = in.read("translation", (Vector2f)null);
        this._rotation = in.read("rotation", 0.0f);
        this._scale = in.read("scale", 1.0f);
        this._matrix = in.read("matrix", (Matrix3f)null);
        if (this._matrix != null) {
            this._type = this._matrix.isAffine() ? 3 : 4;
        } else if (this._translation != null || this._rotation != 0.0f || this._scale != 1.0f) {
            this._translation = this._translation == null ? new Vector2f() : this._translation;
            this._type = this._scale == 1.0f ? 1 : 2;
        } else {
            this._type = 0;
        }
    }

    public String toString() {
        switch (this._type) {
            default: {
                return "[]";
            }
            case 1: {
                return "[" + this._translation + ", " + this._rotation + "]";
            }
            case 2: {
                return "[" + this._translation + ", " + this._rotation + ", " + this._scale + "]";
            }
            case 3: 
            case 4: 
        }
        return this._matrix.toString();
    }

    public int hashCode() {
        switch (this._type) {
            default: {
                return this._type;
            }
            case 1: 
            case 2: {
                int hash = 31 * this._type + this._translation.hashCode();
                hash = 31 * hash + Float.floatToIntBits(this._rotation);
                return this._type == 2 ? 31 * hash + Float.floatToIntBits(this._scale) : hash;
            }
            case 3: 
            case 4: 
        }
        return 31 * this._type + this._matrix.hashCode();
    }

    public boolean equals(Object other) {
        Transform2D otrans = (Transform2D)other;
        if (!(other instanceof Transform2D) || this._type != otrans.getType()) {
            return false;
        }
        switch (this._type) {
            default: {
                return true;
            }
            case 1: {
                return this._translation.equals(otrans.getTranslation()) && this._rotation == otrans.getRotation();
            }
            case 2: {
                return this._translation.equals(otrans.getTranslation()) && this._rotation == otrans.getRotation() && this._scale == otrans.getScale();
            }
            case 3: 
            case 4: 
        }
        return this._matrix.equals(otrans.getMatrix());
    }
}

