/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.tools.AbstractValidatorTask;
import com.threerings.editor.util.Validator;
import com.threerings.resource.ResourceManager;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class ConfigValidatorTask
extends AbstractValidatorTask {
    @Override
    protected boolean validate(ConfigManager cfgmgr, Iterable<File> files, Validator validator) {
        boolean valid = cfgmgr.validateReferences(validator);
        ResourceManager rsrcmgr = cfgmgr.getResourceManager();
        for (File source : files) {
            ManagedConfig config;
            String path = rsrcmgr.getResourcePath(source);
            if (path == null || (config = cfgmgr.getResourceConfig(path)) == null) continue;
            validator.pushWhere(path);
            try {
                try {
                    valid &= config.validateReferences(validator);
                }
                catch (Exception e) {
                    throw new BuildException("Error validating '" + path + "': " + e);
                }
            }
            finally {
                validator.popWhere();
            }
        }
        return valid;
    }
}

