/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.threerings.editor.FileConstraints;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.swing.editors.util.RecentDirectoryList;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileEditor
extends PropertyEditor
implements ActionListener {
    protected JButton _file;
    protected JButton _clear;
    protected JFileChooser _chooser;
    protected static Preferences _prefs = Preferences.userNodeForPackage(FileEditor.class);

    @Override
    public void actionPerformed(ActionEvent event) {
        File value;
        Object source = event.getSource();
        if (source == this._file) {
            String filename;
            int dot;
            final FileConstraints constraints = this._property.getAnnotation(FileConstraints.class);
            String key = constraints == null || constraints.directory().isEmpty() ? null : constraints.directory();
            String ddir = this.getDefaultDirectory();
            if (this._chooser == null) {
                if (this.getPropertyFile() != null) {
                    ddir = this.getPropertyFile().getParentFile().getAbsolutePath();
                }
                this._chooser = new JFileChooser(key == null ? ddir : _prefs.get(key, ddir));
                if (this.getMode().equals("directory")) {
                    this._chooser.setFileSelectionMode(1);
                } else if (constraints != null) {
                    final MessageBundle msgs = this._msgmgr.getBundle(this._property.getMessageBundle());
                    this._chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String name = file.getName();
                            String[] stringArray = constraints.extensions();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String extension = stringArray[n2];
                                if (name.endsWith(extension)) {
                                    return true;
                                }
                                ++n2;
                            }
                            return false;
                        }

                        @Override
                        public String getDescription() {
                            return msgs.xlate(constraints.description());
                        }
                    });
                }
            } else if (this.getPropertyFile() != null) {
                File path = this.getPropertyFile().getParentFile();
                this._chooser.setCurrentDirectory(path);
            } else if (ddir != null) {
                this._chooser.setCurrentDirectory(new File(ddir));
            }
            this._chooser.setSelectedFile(this.getPropertyFile());
            this._chooser.setAccessory(new RecentDirectoryList("files:" + this.getClass().getName()));
            int result = this._chooser.showOpenDialog((Component)((Object)this));
            if (key != null) {
                _prefs.put(key, this._chooser.getCurrentDirectory().toString());
            }
            if (result != 0) {
                return;
            }
            value = this._chooser.getSelectedFile();
            if (constraints != null && constraints.stripExtension() && (dot = (filename = value.toString()).lastIndexOf(46)) > -1 && dot > filename.lastIndexOf(File.pathSeparatorChar)) {
                value = new File(filename.substring(0, dot));
            }
        } else {
            value = null;
        }
        try {
            this.setPropertyFile(value);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this._msgs.get("t.invalid_value"), 0);
        }
        this.update();
        this.fireStateChanged();
    }

    @Override
    public void update() {
        this.updateButtons(this.getPropertyFile());
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
        this._file = new JButton(" ");
        this.add(this._file);
        this._file.addActionListener(this);
        if (this._property.nullable()) {
            this._clear = new JButton(this._msgs.get("m.clear"));
            this.add(this._clear);
            this._clear.addActionListener(this);
        }
    }

    protected void updateButtons(File value) {
        boolean enable = value != null;
        this._file.setText(enable ? value.getName() : this._msgs.get("m.null_value"));
        if (this._clear != null) {
            this._clear.setEnabled(enable);
        }
    }

    protected String getDefaultDirectory() {
        return null;
    }

    protected File getPropertyFile() {
        return (File)this._property.get(this._object);
    }

    protected void setPropertyFile(File file) {
        this._property.set(this._object, file);
    }
}

