/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.RunQueue;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.NoDependency;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.ReferenceConstraints;
import com.threerings.config.swing.ConfigChooser;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.editor.Property;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.openal.SoundManager;
import com.threerings.opengl.GlCanvas;
import com.threerings.opengl.model.tools.ModelViewer;
import com.threerings.resource.Log;
import com.threerings.util.MessageBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigReferenceEditor
extends PropertyEditor
implements ActionListener,
ChangeListener,
ConfigUpdateListener<ManagedConfig> {
    static ConfigManager OUTER = null;
    protected JButton _config;
    protected JButton _edit;
    protected JButton _view;
    protected JButton _clear;
    protected JButton _sync;
    protected JPanel _arguments;
    protected JLabel _name;
    protected ConfigChooser _chooser;
    protected ParameterizedConfig _listenee;

    @Override
    public void actionPerformed(ActionEvent event) {
        ConfigReference nvalue;
        ConfigReference ovalue = (ConfigReference)this._property.get(this._object);
        Object source = event.getSource();
        if (source == this._config) {
            if (this._chooser == null) {
                this._chooser = ConfigChooser.createInstance(this._msgmgr, this._ctx.getConfigManager(), this.getArgumentType(), this.getProperty().getAnnotation(ReferenceConstraints.class));
            }
            String oldConfig = ovalue == null ? null : ovalue.getName();
            this._chooser.setListener(new ConfigChooser.ChoseListener(oldConfig){

                @Override
                public void onChange(String config) {
                    ConfigReference nvalue = config == null ? null : new ConfigReference(config);
                    ConfigReferenceEditor.this._property.set(ConfigReferenceEditor.this._object, nvalue);
                    ConfigReferenceEditor.this.update(nvalue, true);
                    ConfigReferenceEditor.this.fireStateChanged();
                }
            });
            this._chooser.setSelectedConfig(oldConfig);
            if (!this._chooser.showDialog((Component)((Object)this))) {
                return;
            }
            String config = this._chooser.getSelectedConfig();
            ConfigReference configReference = nvalue = config == null ? null : new ConfigReference(config);
            if (nvalue != null && !this.validateNewValue(this.getProperty(), nvalue)) {
                return;
            }
        } else {
            if (source == this._view) {
                ModelViewer viewer = new ModelViewer(ovalue){

                    @Override
                    protected void initSharedManagers() {
                        this._rsrcmgr = ConfigReferenceEditor.this._ctx.getResourceManager();
                        this._msgmgr = ConfigReferenceEditor.this._ctx.getMessageManager();
                        this._cfgmgr = ConfigReferenceEditor.this._ctx.getConfigManager();
                        this._colorpos = ConfigReferenceEditor.this._ctx.getColorPository();
                        try {
                            this._soundmgr = SoundManager.createSoundManager((RunQueue)this.getRunQueue());
                        }
                        catch (IllegalStateException e) {
                            this._ownerSoundmgr = false;
                        }
                    }

                    @Override
                    public void shutdown() {
                        this.willShutdown();
                        ((GlCanvas)((Object)this._canvas)).shutdown();
                    }
                };
                viewer.startup();
                return;
            }
            if (source == this._edit) {
                BaseConfigEditor editor = BaseConfigEditor.createEditor(this._ctx, this.getArgumentType(), ovalue.getName());
                editor.setLocationRelativeTo((Component)((Object)this));
                editor.setVisible(true);
                return;
            }
            if (source == this._sync) {
                Class<?> type = this._property.getArgumentType(ConfigReference.class);
                ConfigManager manager = this._ctx.getConfigManager();
                while (manager.getParent() != null) {
                    manager = manager.getParent();
                }
                ConfigGroup<?> group = manager.getGroup(type);
                Object config = OUTER.getConfig(type, ovalue.getName());
                if (config != null) {
                    try {
                        group.addConfig((ManagedConfig)config);
                        ConfigReference nvalue2 = config == null ? null : new ConfigReference(ovalue.getName());
                        this._property.set(this._object, new ConfigReference(ovalue.getName()));
                        this.update(nvalue2, true);
                        this.fireStateChanged();
                    }
                    catch (Exception e) {
                        Log.log.warning((Object)"sync error", new Object[]{e});
                        group.removeConfig((ManagedConfig)config);
                        this._config.setForeground(Color.red);
                    }
                }
                return;
            }
            if (source == this._clear) {
                nvalue = null;
            } else {
                super.actionPerformed(event);
                return;
            }
        }
        this._property.set(this._object, nvalue);
        this.update(nvalue, true);
        this.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        this.update();
    }

    public void addNotify() {
        super.addNotify();
        if (this._listenee != null) {
            this.update();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._listenee != null) {
            this._listenee.removeListener(this);
        }
    }

    @Override
    public void update() {
        this.update((ConfigReference)this._property.get(this._object), false);
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        PropertyEditor editor = this.getNextChildComponent(PropertyEditor.class, comp);
        return editor == null ? "" : "[\"" + editor.getProperty().getName().replace("\"", "\\\"") + "\"]" + editor.getComponentPath(comp, mouse);
    }

    protected Class<?> getArgumentType() {
        return this._property.getArgumentType(ConfigReference.class);
    }

    public static synchronized void initOuter(EditorContext ctx) {
        if (OUTER == null && ctx.getResourceManager().getResourceFile("config.outer/manager.properties") != null) {
            OUTER = new ConfigManager(ctx.getResourceManager(), ctx.getMessageManager(), "config.outer");
            OUTER.init();
        }
    }

    public static ConfigManager getOuterManager() {
        return OUTER;
    }

    @Override
    protected void didInit() {
        ConfigReferenceEditor.initOuter(this._ctx);
        if (this._property.getAnnotation().constant()) {
            this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
            this._name = new JLabel(" ");
            this.add(this._name);
            return;
        }
        this.makeCollapsible(this._ctx, this.getPropertyLabel(), false);
        JPanel cpanel = new JPanel();
        this._content.add(cpanel);
        cpanel.add(new JLabel(String.valueOf(this._msgs.get("m.config")) + ":"));
        this._config = new JButton(" ");
        cpanel.add(this._config);
        cpanel.setBackground(null);
        this._config.addActionListener(this);
        if (!this.getMode().equals("compact")) {
            this._edit = new JButton(this._msgs.get("m.edit"));
            cpanel.add(this._edit);
            this._edit.addActionListener(this);
        }
        Class<?> clazz = this.getArgumentType();
        if (this._property.nullable()) {
            this._clear = new JButton(this._msgs.get("m.clear"));
            cpanel.add(this._clear);
            this._clear.addActionListener(this);
        }
        if (OUTER != null) {
            this._sync = new JButton(this._msgs.get("m.sync"));
            cpanel.add(this._sync);
            this._sync.addActionListener(this);
            this._sync.setVisible(false);
        }
        this._arguments = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._content.add(this._arguments);
        this._arguments.setBackground(null);
    }

    protected boolean validateNewValue(Property property, ConfigReference<?> value) {
        ReferenceConstraints constraints = property.getAnnotation(ReferenceConstraints.class);
        ManagedConfig conf = this._ctx.getConfigManager().getResourceConfig(value.getName());
        if (conf == null) {
            return true;
        }
        MessageBundle msgs = this._ctx.getMessageManager().getBundle("editor.config");
        if (constraints != null) {
            Class<? extends ManagedConfig>[] clsses;
            Class<? extends ManagedConfig>[] classArray = clsses = constraints.value();
            int n = clsses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends ManagedConfig> clazz = classArray[n2];
                if (clazz == conf.getClass()) {
                    return true;
                }
                ++n2;
            }
            String desc = constraints.description();
            List<Class<? extends ManagedConfig>> vals = Arrays.asList(constraints.value());
            if ("".equals(desc)) {
                desc = Joiner.on((String)", ").join(Iterables.transform(vals, (Function)new Function<Class<?>, String>(){

                    public String apply(Class<?> clazz) {
                        return ConfigGroup.getName(clazz);
                    }
                }));
                desc = "file type must in ( " + desc + " )";
            } else if (msgs.exists(desc)) {
                desc = msgs.get(desc);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), desc, msgs.get("m.type_error"), 2);
            return false;
        }
        if (property.getType() == ConfigReference.class) {
            Type[] types;
            Type genericType = property.getGenericType();
            if (genericType instanceof ParameterizedType && (types = ((ParameterizedType)genericType).getActualTypeArguments()) != null) {
                Type[] typeArray = types;
                int n = types.length;
                int n3 = 0;
                while (n3 < n) {
                    Type type = typeArray[n3];
                    if (type == conf.getClass()) {
                        return true;
                    }
                    ++n3;
                }
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "m.type_mismatch", msgs.get("m.type_error"), 2);
            return false;
        }
        return true;
    }

    protected void update(ConfigReference<?> value, boolean transfer) {
        boolean enable;
        if (this._listenee != null) {
            this._listenee.removeListener(this);
            this._listenee = null;
        }
        if (this._property.getAnnotation().constant()) {
            this._name.setText(value == null ? this._msgs.get("m.null_value") : value.getName());
            return;
        }
        boolean bl = enable = value != null;
        if (this._edit != null) {
            this._edit.setEnabled(enable);
        }
        if (this._clear != null) {
            this._clear.setEnabled(enable);
        }
        if (this._view != null) {
            this._view.setEnabled(enable);
        }
        if (!enable) {
            this._config.setText(this._msgs.get("m.null_value"));
            this._arguments.removeAll();
            this._config.setForeground(this._property.nullable() ? this._content.getForeground() : Color.red);
            return;
        }
        String name = value.getName();
        this._config.setToolTipText(name);
        this._config.setText(name.substring(name.lastIndexOf(47) + 1));
        Class<?> clazz = this.getArgumentType();
        ManagedConfig config = this._ctx.getConfigManager().getRawConfig(clazz, name);
        if (!(config instanceof ParameterizedConfig) || this.getProperty().isAnnotationPresent(NoDependency.class)) {
            this._arguments.removeAll();
            value.getArguments().clear();
            if (config == null) {
                this._config.setForeground(Color.red);
            }
            if (OUTER != null) {
                if (config == null) {
                    this._sync.setVisible(true);
                } else {
                    this._sync.setVisible(false);
                }
            }
            return;
        }
        if (!PropertyUtil.getRawConfigPredicate(this.getProperty().getAnnotation(ReferenceConstraints.class)).apply((Object)config)) {
            this._config.setForeground(Color.red);
            return;
        }
        this._config.setForeground(this._content.getForeground());
        int ocount = this._arguments.getComponentCount();
        HashMap<String, PropertyEditor> oeditors = new HashMap<String, PropertyEditor>();
        if (transfer) {
            int ii = 0;
            while (ii < ocount) {
                PropertyEditor editor = (PropertyEditor)((Object)this._arguments.getComponent(ii));
                oeditors.put(editor.getProperty().getName(), editor);
                ++ii;
            }
        }
        int idx = 0;
        ArgumentMap nargs = value.getArguments();
        ParameterizedConfig pconfig = (ParameterizedConfig)config;
        Parameter[] parameterArray = pconfig.parameters;
        int n = pconfig.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            Property property = parameter.getArgumentProperty(pconfig);
            if (property != null) {
                PropertyEditor oeditor;
                PropertyEditor editor = null;
                if (idx < ocount) {
                    oeditor = (PropertyEditor)((Object)this._arguments.getComponent(idx));
                    if (oeditor.getProperty().equals(property)) {
                        if (transfer) {
                            property.set(nargs, property.get(oeditor.getObject()));
                        }
                        editor = oeditor;
                    } else {
                        this._arguments.remove(idx);
                    }
                }
                if (editor == null) {
                    editor = PropertyEditor.createEditor(this._ctx, property, this._lineage);
                    editor.addChangeListener(this);
                    this._arguments.add((Component)((Object)editor), idx);
                    oeditor = (PropertyEditor)oeditors.get(parameter.name);
                    if (oeditor != null) {
                        Object ovalue;
                        Property oproperty = oeditor.getProperty();
                        if (property.getGenericType().equals(oproperty.getGenericType()) && property.isLegalValue(ovalue = oproperty.get(oeditor.getObject()))) {
                            property.set(nargs, ovalue);
                        }
                    }
                }
                editor.setObject(nargs);
                ++idx;
            }
            ++n2;
        }
        while (ocount > idx) {
            this._arguments.remove(--ocount);
        }
        SwingUtil.refresh((JComponent)this._arguments);
        Iterator it = value.getArguments().keySet().iterator();
        while (it.hasNext()) {
            if (pconfig.getParameter((String)it.next()) != null) continue;
            it.remove();
        }
        this._listenee = pconfig;
        this._listenee.addListener(this);
    }
}

