/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.QuaternionPanel;
import com.threerings.editor.swing.Vector3fPanel;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Transform3DPanel
extends BasePropertyEditor
implements ChangeListener {
    protected Mode _mode;
    protected Vector3fPanel _tpanel;
    protected QuaternionPanel _rpanel;
    protected JSpinner _sspinner;

    public Transform3DPanel(MessageBundle msgs, Mode mode, float step, float scale) {
        this._msgs = msgs;
        this._mode = mode;
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.setBackground(null);
        JPanel trpanel = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
        trpanel.setBackground(null);
        this.add(trpanel);
        JPanel tcont = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
        tcont.setBackground(null);
        tcont.setBorder(BorderFactory.createTitledBorder(this.getLabel("translation")));
        trpanel.add(tcont);
        this._tpanel = new Vector3fPanel(msgs, Vector3fPanel.Mode.CARTESIAN, step, scale);
        tcont.add((Component)((Object)this._tpanel));
        this._tpanel.addChangeListener(this);
        JPanel rcont = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
        rcont.setBackground(null);
        rcont.setBorder(BorderFactory.createTitledBorder(this.getLabel("rotation")));
        trpanel.add(rcont);
        this._rpanel = new QuaternionPanel(msgs, QuaternionPanel.Mode.XYZ);
        rcont.add((Component)((Object)this._rpanel));
        this._rpanel.addChangeListener(this);
        if (this._mode == Mode.RIGID) {
            return;
        }
        JPanel spanel = new JPanel();
        spanel.setBackground(null);
        this.add(spanel);
        spanel.add(new JLabel(String.valueOf(this.getLabel("scale")) + ":"));
        this._sspinner = new DraggableSpinner(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(step));
        spanel.add(this._sspinner);
        this._sspinner.addChangeListener(this);
    }

    public Vector3fPanel getTranslationPanel() {
        return this._tpanel;
    }

    public QuaternionPanel getRotationPanel() {
        return this._rpanel;
    }

    public void setValue(Transform3D value) {
        value.update(2);
        this._tpanel.setValue(value.getTranslation());
        this._rpanel.setValue(value.getRotation());
        if (this._mode == Mode.UNIFORM) {
            this._sspinner.setValue(Float.valueOf(value.getScale()));
        }
    }

    public Transform3D getValue() {
        float scale;
        Vector3f translation = this._tpanel.getValue();
        Quaternion rotation = this._rpanel.getValue();
        float f = scale = this._sspinner == null ? 1.0f : ((Number)this._sspinner.getValue()).floatValue();
        if (scale == 1.0f) {
            return translation.equals(Vector3f.ZERO) && rotation.equals(Quaternion.IDENTITY) ? new Transform3D() : new Transform3D(translation, rotation);
        }
        return new Transform3D(translation, rotation, scale);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    public static enum Mode {
        RIGID,
        UNIFORM;

    }
}

