/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ConfigReferenceSet {
    public abstract <T extends ManagedConfig> boolean add(Class<T> var1, @Nullable ConfigReference<T> var2);

    public <T extends ManagedConfig> boolean add(Class<T> clazz, @Nullable String name) {
        return name != null && this.add(clazz, new ConfigReference(name));
    }

    public <T extends ManagedConfig> boolean addAll(Class<T> clazz, @Nullable List<ConfigReference<T>> list) {
        if (list == null) {
            return false;
        }
        boolean anyAdded = false;
        for (ConfigReference<T> ref : list) {
            anyAdded |= this.add(clazz, ref);
        }
        return anyAdded;
    }

    public <T extends ManagedConfig> boolean addAll(Class<T> clazz, @Nullable ConfigReference<T>[] array) {
        return array != null && this.addAll(clazz, Arrays.asList(array));
    }

    public abstract SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> getRefsMap();

    public static class Default
    extends ConfigReferenceSet {
        protected SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> _refs = HashMultimap.create();

        public SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> getGathered() {
            return this._refs;
        }

        @Override
        public <T extends ManagedConfig> boolean add(Class<T> clazz, @Nullable ConfigReference<T> ref) {
            return ref != null && this._refs.put(clazz, ref);
        }

        @Override
        public SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> getRefsMap() {
            return this._refs;
        }
    }
}

