/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.samskivert.util.ObserverList;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ConfigManager;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.EditorTypes;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.export.util.LazyOutputStream;
import com.threerings.util.Copyable;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ConfigGroup<T extends ManagedConfig>
implements Copyable,
Exportable {
    protected ConfigManager _cfgmgr;
    protected String _name;
    protected Class<T> _cclass;
    protected HashMap<String, ManagedConfig> _configsByName = new HashMap();
    protected ObserverList<ConfigGroupListener> _listeners;

    public static String getName(Class<?> clazz) {
        String cstr = clazz.getName();
        cstr = (cstr = cstr.substring(Math.max(cstr.lastIndexOf(46), cstr.lastIndexOf(36)) + 1)).endsWith("Config") ? cstr.substring(0, cstr.length() - 6) : cstr;
        return StringUtil.toUSLowerCase((String)StringUtil.unStudlyName((String)cstr));
    }

    public ConfigGroup(Class<T> clazz) {
        this.initConfigClass(clazz);
    }

    public ConfigGroup() {
    }

    public void init(ConfigManager cfgmgr) {
        this.init(cfgmgr, new ConfigManager.Consumer<Exception>(){

            @Override
            public void accept(Exception e) {
            }
        });
    }

    public void init(ConfigManager cfgmgr, ConfigManager.Consumer<Exception> exceptionConsumer) {
        this._cfgmgr = cfgmgr;
        if (this._cfgmgr.getConfigPath() != null && (this.readConfigs(true, exceptionConsumer) || this.readConfigs(false, exceptionConsumer))) {
            ClydeLog.log.debug((Object)("Read configurations for group " + this._name + "."), new Object[0]);
        }
        for (ManagedConfig config : this.getRawConfigs()) {
            this.initConfig(config);
        }
    }

    public String getName() {
        return this._name;
    }

    public Class<T> getConfigClass() {
        return this._cclass;
    }

    public List<Class<?>> getRawConfigClasses() {
        EditorTypes anno = this._cclass.getAnnotation(EditorTypes.class);
        return anno == null ? ImmutableList.of(this._cclass) : ImmutableList.copyOf((Object[])anno.value());
    }

    public T getConfig(String name) {
        return this.actualize(this.getRawConfig(name));
    }

    public ManagedConfig getRawConfig(String name) {
        return this._configsByName.get(name);
    }

    public Iterable<T> getConfigs() {
        return Iterables.transform(this.getRawConfigs(), (Function)new Function<ManagedConfig, T>(){

            public T apply(ManagedConfig cfg) {
                return ConfigGroup.this.actualize(cfg);
            }
        });
    }

    public Iterable<ManagedConfig> getRawConfigs() {
        return this._configsByName.values();
    }

    public void addListener(ConfigGroupListener listener) {
        if (this._listeners == null) {
            this._listeners = ObserverList.newFastUnsafe();
        }
        this._listeners.add((Object)listener);
    }

    public void removeListener(ConfigGroupListener listener) {
        if (this._listeners != null) {
            this._listeners.remove((Object)listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    public void addConfigs(Collection<? extends ManagedConfig> configs) {
        for (ManagedConfig managedConfig : configs) {
            this.addConfig(managedConfig);
        }
    }

    public void addConfig(ManagedConfig config) {
        this.addConfig(config, true);
    }

    public void addConfig(ManagedConfig config, boolean fireEvents) {
        if (!this._cclass.isInstance(config) && !(config instanceof DerivedConfig)) {
            Class<?> clazz = config == null ? null : config.getClass();
            throw new IllegalArgumentException(clazz + " is not of type " + this._cclass);
        }
        ManagedConfig oldCfg = this._configsByName.put(config.getName(), config);
        this.initConfig(config);
        if (fireEvents) {
            if (oldCfg != null) {
                oldCfg.wasUpdated();
                this.fireConfigRemoved(oldCfg);
            }
            this.fireConfigAdded(config);
        }
    }

    public void removeConfig(ManagedConfig config) {
        ManagedConfig oldCfg = this._configsByName.remove(config.getName());
        if (oldCfg != null) {
            oldCfg.wasUpdated();
            this.fireConfigRemoved(oldCfg);
        }
    }

    public final void save() {
        this.save(this.getConfigFile(true));
    }

    public final void save(File file) {
        this.save(file, true);
    }

    public final void save(File file, boolean xml) {
        this.save(this.getRawConfigs(), file, xml);
    }

    public final void save(Iterable<? extends ManagedConfig> rawConfigs, File file) {
        this.save(rawConfigs, file, true);
    }

    public void save(Iterable<? extends ManagedConfig> rawConfigs, File file, boolean xml) {
        ManagedConfig[] array = this.toSaveableArray(rawConfigs);
        if (array == null) {
            return;
        }
        try (Closer closer = Closer.create();){
            LazyOutputStream stream = (LazyOutputStream)closer.register((Closeable)new LazyOutputStream(file));
            Exporter xport = (Exporter)closer.register((Closeable)(xml ? new XMLExporter(stream) : new BinaryExporter(stream)));
            xport.setReplacer(this._cfgmgr.getSaveReplacer(this));
            xport.writeObject(array);
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)("Error writing configurations [file=" + file + "]."), new Object[]{e});
        }
    }

    public ManagedConfig[] toSaveableArray() {
        return this.toSaveableArray(this.getRawConfigs());
    }

    protected ManagedConfig[] toSaveableArray(Iterable<? extends ManagedConfig> rawConfigs) {
        Class clazz = Iterables.any(rawConfigs, (Predicate)Predicates.instanceOf(DerivedConfig.class)) ? ManagedConfig.class : this._cclass;
        return this._cfgmgr.toSaveableArray(this._cclass, rawConfigs, clazz);
    }

    public void revert() {
        this.load(this.getConfigFile(true));
    }

    public final void load(File file) {
        this.load(file, false);
    }

    public void load(File file, boolean merge) {
        ManagedConfig[] array;
        try {
            XMLImporter in = new XMLImporter(new FileInputStream(file));
            array = (ManagedConfig[])((Importer)in).readObject();
            ((Importer)in).close();
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)("Error reading configurations [file=" + file + "]."), new Object[]{e});
            return;
        }
        this.validateOuters(array);
        this.load(Arrays.asList(array), merge, false);
    }

    public void writeFields(Exporter out) throws IOException {
        ManagedConfig[] array = this._cfgmgr != null ? this._cfgmgr.toSaveableArray(this._cclass, this.getRawConfigs(), ManagedConfig.class) : (ManagedConfig[])Iterables.toArray(this.getRawConfigs(), ManagedConfig.class);
        out.write("configs", array, null, Object.class);
        out.write("class", String.valueOf(this._cclass.getName()));
    }

    public void readFields(Importer in) throws IOException {
        Class<?> clazz;
        ManagedConfig[] configs = (ManagedConfig[])in.read("configs", null, Object.class);
        String classname = in.read("class", (String)null);
        if (classname != null) {
            try {
                clazz = Class.forName(classname);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unknown class: " + classname).initCause(e);
            }
        } else {
            clazz = configs.getClass().getComponentType();
        }
        Class<?> tclazz = clazz;
        this.initConfigClass(tclazz);
        this.initConfigs(configs);
    }

    @Override
    public Object copy(Object dest) {
        return this.copy(dest, null);
    }

    @Override
    public Object copy(Object dest, Object outer) {
        ConfigGroup<T> other = dest instanceof ConfigGroup ? (ConfigGroup<T>)dest : new ConfigGroup<T>(this._cclass);
        other.load(this.getRawConfigs(), false, true);
        return other;
    }

    protected void initConfigClass(Class<T> clazz) {
        this._cclass = clazz;
        this._name = ConfigGroup.getName(clazz);
    }

    protected boolean readConfigs(boolean xml, ConfigManager.Consumer<Exception> exceptionConsumer) {
        ManagedConfig[] configs;
        InputStream stream = this.getConfigStream(xml);
        if (stream == null) {
            return false;
        }
        try {
            Importer in = xml ? new XMLImporter(stream) : new BinaryImporter(stream);
            configs = (ManagedConfig[])in.readObject();
            in.close();
        }
        catch (Exception e) {
            exceptionConsumer.accept(e);
            ClydeLog.log.warning((Object)"Error reading configurations.", new Object[]{"group", this._name, e});
            return false;
        }
        if (xml) {
            this.validateOuters(configs);
        }
        this.initConfigs(configs);
        return true;
    }

    protected InputStream getConfigStream(boolean xml) {
        try {
            return this._cfgmgr.getResourceManager().getResource(this.getConfigPath(xml));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected File getConfigFile(boolean xml) {
        return this._cfgmgr.getResourceManager().getResourceFile(this.getConfigPath(xml));
    }

    protected String getConfigPath(boolean xml) {
        return String.valueOf(this._cfgmgr.getConfigPath()) + this._name + (xml ? ".xml" : ".dat");
    }

    protected void validateOuters(ManagedConfig[] configs) {
        ManagedConfig[] managedConfigArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ManagedConfig config = managedConfigArray[n2];
            if (!(config instanceof DerivedConfig)) {
                config.validateOuters(String.valueOf(this._name) + ":" + config.getName());
            }
            ++n2;
        }
    }

    protected void initConfigs(ManagedConfig[] configs) {
        ManagedConfig[] managedConfigArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ManagedConfig config = managedConfigArray[n2];
            this.initConfig(config);
            this._configsByName.put(config.getName(), config);
            ++n2;
        }
    }

    protected void initConfig(ManagedConfig config) {
        config.init(this._cfgmgr);
        if (config instanceof DerivedConfig) {
            ((DerivedConfig)config).cclass = this._cclass;
        }
    }

    protected void load(Iterable<ManagedConfig> nconfigs, boolean merge, boolean clone) {
        HashSet<String> names = new HashSet<String>();
        for (ManagedConfig nconfig : nconfigs) {
            ManagedConfig copied;
            String name = nconfig.getName();
            names.add(name);
            ManagedConfig oconfig = this.getRawConfig(name);
            if (oconfig == null) {
                this.addConfig(clone ? (ManagedConfig)nconfig.clone() : nconfig);
                continue;
            }
            if (nconfig.equals(oconfig)) continue;
            if (nconfig instanceof DerivedConfig) {
                ((DerivedConfig)nconfig).cclass = this._cclass;
            }
            if ((copied = (ManagedConfig)nconfig.copy(oconfig)) == oconfig) {
                oconfig.wasUpdated();
                continue;
            }
            this.removeConfig(oconfig);
            this.addConfig(copied);
        }
        if (merge) {
            return;
        }
        for (ManagedConfig cfg : Lists.newArrayList(this.getRawConfigs())) {
            if (names.contains(cfg.getName())) continue;
            this.removeConfig(cfg);
        }
    }

    protected T actualize(ManagedConfig val) {
        if (val instanceof DerivedConfig) {
            val = val.getInstance((ArgumentMap)null);
        }
        return (T)((ManagedConfig)this._cclass.cast(val));
    }

    protected void fireConfigAdded(ManagedConfig config) {
        if (this._listeners == null) {
            return;
        }
        final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, config);
        this._listeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigGroupListener>(){

            public boolean apply(ConfigGroupListener listener) {
                listener.configAdded(event);
                return true;
            }
        });
    }

    protected void fireConfigRemoved(ManagedConfig config) {
        if (this._listeners == null) {
            return;
        }
        final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, config);
        this._listeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigGroupListener>(){

            public boolean apply(ConfigGroupListener listener) {
                listener.configRemoved(event);
                return true;
            }
        });
    }

    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }
}

