package com.threerings.util;

import java.util.concurrent.atomic.AtomicInteger;

import com.samskivert.util.ObjectUtil;

public class ThreadLocalLogger {
	private static boolean isDebug = false;
	private static ThreadLocal<Object> local = new ThreadLocal<Object>();
	private static AtomicInteger index = new AtomicInteger(0);

	public static void start(Object obj,String phaser, Object msg) {
		if (isDebug) {
			local.set(obj);
			System.out.println("<<start index=" + (index.getAndIncrement()) + ","+phaser+"," + msg);
		}
	}

	public static void stop(Object obj,String phaser, Object msg) {
		if (isDebug) {
			if (ObjectUtil.equals(obj, local.get())) {
				local.set(null);
				System.out.println(">>>end index=" + (index.getAndIncrement()) + ","+phaser+","+ msg);
			}
		}
	}

	public static void log(String phaser, Object msg) {
		if (isDebug) {
			if (local.get() != null) {
				System.out.println("index=" + (index.getAndIncrement()) + ","+phaser+"," + msg);
			}
		}
	}
}
