package com.threerings.tudey.server.graph;

import java.util.LinkedHashMap;
import java.util.Map;

import com.threerings.math.Vector2f;

public class Node {
	private String name;
	private Vector2f location;
	private Map<Node, Integer> neighbors;		// map that contains {neighbor of this node, distance to neighbor}.
	private Node source;					// where the chosen node came from.
	private boolean checked = false;
	private int heuristic;						// node's heuristic.
	
	public Node(String name, Vector2f location, int heuristic) {
		this.name = name;
		this.location = location;
		this.heuristic = heuristic;
		neighbors = new LinkedHashMap();
	}
	
	public String getName() {
		return name;
	}
	
	public void setSource(Node source) {
		this.source = source;
	}
	
	public Node getSource() {
		return source;
	}
	
	public boolean isChecked() {
		return checked;
	}

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public Vector2f getLocation() {
		return location;
	}
	
	public int getHeuristic() {
		return heuristic;
	}
	
	public void addNeighbor(Node neighbor, int distance) {
		this.neighbors.put(neighbor, distance);
	}
	
	public Map<Node, Integer> getNeighbors() {
		return neighbors;
	}

	@Override
	public String toString() {
		String out = "";
		
		out = "[" + " name = " + this.name + ", neighbors = [ ";
		for (Node node : this.neighbors.keySet()) {
			out += node.getName() + " ";
		}
		out += "] ]";
		
		return out;
	}
}

