//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.opengl.gui;

import org.lwjgl.opengl.Display;

import com.samskivert.util.StringUtil;

import com.threerings.opengl.util.GlContext;

/**
 * A derivation of {@link TextField} that does not display the actual
 * text, but asterisks instead.
 */
public class PasswordField extends TextField
{
    public PasswordField (GlContext ctx)
    {
        super(ctx);
    }

    public PasswordField (GlContext ctx, int maxLength)
    {
        super(ctx, maxLength);
    }

    public PasswordField (GlContext ctx, String text)
    {
        super(ctx, text);
    }

    public PasswordField (GlContext ctx, String text, int maxLength)
    {
        super(ctx, text, maxLength);
    }

    // documentation inherited
    protected String getDisplayText ()
    {
        String text = super.getDisplayText();
        if (text == null || (!hasFocus() && usePlaceholder())) {
            return text;
        }

        if (_stars == null || _stars.length() != text.length()) {
            _stars = StringUtil.fill('*', text.length());
        }
        return _stars;
    }
    
    protected void gainedFocus ()
    {
        super.gainedFocus();
        Display.setIMEStatus(false);
    }

    protected String _stars;
}
