//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.opengl.gui;

import com.threerings.opengl.util.GlContext;

import com.threerings.opengl.gui.layout.GroupLayout;

/**
 * A top-level window with a border, a background and a title bar. Note that a
 * decorated window uses a stretching {@link GroupLayout} and adds a label at
 * the top in the <code>window_title</code> style if a title was specified.
 */
public class DecoratedWindow extends Window {
	
	protected Container _cont;
	
	/**
	 * Creates a decorated window using the supplied look and feel.
	 *
	 * @param title
	 *            the title of the window or null if no title bar is desired.
	 */
	public DecoratedWindow(GlContext ctx, String title) {
		super(ctx, GroupLayout.makeVStretch());
		
		Container hcont = new Container(ctx, GroupLayout.makeHoriz(GroupLayout.STRETCH, GroupLayout.CENTER, GroupLayout.CONSTRAIN));
		Container titleCont = new Container(ctx, GroupLayout.makeHoriz(GroupLayout.NONE, GroupLayout.CENTER, GroupLayout.CONSTRAIN));
		
		Label label = new Label(ctx, (title == null ? " " : title));
		label.setStyleConfig("Default_V2/DecoratedTitle");
		
		titleCont.add(label);
		hcont.add(titleCont);
		this.add(hcont, GroupLayout.FIXED);
		
		Spacer aa = new Spacer(ctx, -1, 6);
		this.add(aa, GroupLayout.FIXED);
		
		this._cont = new Container(ctx, GroupLayout.makeVert(GroupLayout.NONE, GroupLayout.CENTER, GroupLayout.CONSTRAIN).setGap(8));
		this._cont.setStyleConfig("Default_V2/DecoratedContainer");
		this.add(this._cont);
	}

	@Override // documentation inherited
	protected String getDefaultStyleConfig() {
		return "Default_V2/DecoratedWindow";
	}
	
	public Container getContainer() {
		return this._cont;
	}
}
