//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.editor.swing.editors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.samskivert.util.Config;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;

import com.threerings.editor.swing.PropertyEditor;

import static com.threerings.editor.Log.*;

/**
 * Provides a means of selecting between several different objects.
 */
public class ArrayMaskEditor extends PropertyEditor
    implements ActionListener
{
	/**
     * Retrieves the value of an index from the configuration, or -1 if not found.
     */
    public static int getIndex (String mode, String flag)
    {
        String[] flags = _modes.get(mode);
        int idx = (flags == null) ? -1 : ListUtil.indexOf(flags, flag);
        return idx;
    }
    
    // documentation inherited from interface ActionListener
    public void actionPerformed (ActionEvent event)
    {
        Object selected = _box.getSelectedItem();
        if (!Objects.equal(_property.get(_object), selected)) {
            _property.set(_object, selected);
            fireStateChanged();
        }
    }

    @Override // documentation inherited
    public void update ()
    {
        Object[] options = getOptions();
        _box.setModel(new DefaultComboBoxModel(options));
        _box.setSelectedItem(_property.get(_object));
    }

    @Override // documentation inherited
    protected void didInit ()
    {
        add(new JLabel(getPropertyLabel() + ":"));
        add(_box = new JComboBox());
        _box.addActionListener(this);
        
        String mode = getMode();
    	String[] names = _modes.get(mode);
        
    	if ((names == null) || (names.length == 0)) {
    		_flags = new String[0];
    	} else {
    		_flags = names;
    	}
    }

    /**
     * Returns the array of options available for selection.
     */
    protected Object[] getOptions ()
    {
    	return _flags;
    }

    /** The combo box. */
    protected JComboBox _box;
    
    /** mode flags. */
    protected String[] _flags;
    
    /** The names of the flags for each mode. */
    protected static Map<String, String[]> _modes = Maps.newHashMap();
    
    static {
        // load the modes from the configuration
        Config config = new Config("/rsrc/config/editor/arraymask");
        for (Iterator<String> it = config.keys(); it.hasNext(); ) {
            String key = it.next();
            _modes.put(key, config.getValue(key, new String[0]));
        }
    }
}
