/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;
import java.io.IOException;

public class InputFrame
extends DeepObject
implements Streamable {
    public static final int MOVE = 1;
    public static final int RUMMAGE = 2;
    public static final int ACTION = 4;
    public static final int LAST_FLAG = 4;
    protected int _timestamp;
    protected float _rotation;
    protected float _direction;
    protected int _flags;
    protected int _actionChanged;
    public int _targetId;

    public int getTargetId() {
        return this._targetId;
    }

    public void setTargetId(int targetId) {
        this._targetId = targetId;
    }

    public int getActionChanged() {
        return this._actionChanged;
    }

    public InputFrame(int timestamp, float rotation, float direction, int flags, int actionChanged, int targetSpriteId) {
        this._timestamp = timestamp;
        this._rotation = rotation;
        this._direction = direction;
        this._flags = flags;
        this._actionChanged = actionChanged;
        this._targetId = targetSpriteId;
    }

    public InputFrame() {
    }

    public int getTimestamp() {
        return this._timestamp;
    }

    public float getRotation() {
        return this._rotation;
    }

    public float getDirection() {
        return this._direction;
    }

    public int getFlags() {
        return this._flags;
    }

    public boolean isSet(int flag) {
        return (this._flags & flag) != 0;
    }

    public int getApproximateSize() {
        return 18;
    }

    @Override
    public String toString() {
        return "[timestamp=" + this._timestamp + ", rotation=" + this._rotation + ", direction=" + this._direction + ", flags=" + this._flags + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (this.getClass().equals(other.getClass())) {
            InputFrame o = (InputFrame)other;
            boolean isEq = this._rotation == o._rotation && this._direction == o._direction && this._flags == o._flags && this._actionChanged == o._actionChanged;
            return isEq;
        }
        return false;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._timestamp);
        out.writeFloat(this._rotation);
        out.writeFloat(this._direction);
        out.writeInt(this._flags);
        out.writeInt(this._actionChanged);
        out.writeInt(this._targetId);
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._timestamp = in.readInt();
        this._rotation = in.readFloat();
        this._direction = in.readFloat();
        this._flags = in.readInt();
        this._actionChanged = in.readInt();
        this._targetId = in.readInt();
    }
}

