/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.opengl.Log;
import com.threerings.opengl.util.Tickable;
import java.lang.reflect.Method;

public abstract class Phaser
implements Tickable {
    protected Method[] _methods;
    protected float[] _durations;
    protected int _phase;
    protected float _accum;
    protected float _pct;
    protected float _cpct;

    public Phaser(Object ... params) {
        int nparams = params.length;
        if (nparams % 2 != 0) {
            throw new IllegalArgumentException("Number of parameters must be even.");
        }
        int nphases = nparams / 2;
        this._methods = new Method[nphases];
        this._durations = new float[nphases];
        int ii = 0;
        while (ii < nphases) {
            try {
                String mname = (String)params[ii * 2];
                if (mname != null) {
                    this._methods[ii] = this.getClass().getDeclaredMethod(mname, new Class[0]);
                    this._methods[ii].setAccessible(true);
                }
                this._durations[ii] = ((Float)params[ii * 2 + 1]).floatValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid phase parameter.", e);
            }
            ++ii;
        }
    }

    @Override
    public void tick(float elapsed) {
        int nphases = this._durations.length;
        if (this._phase == nphases) {
            return;
        }
        this._accum += elapsed;
        while (this._accum >= this._durations[this._phase]) {
            this.update(this._phase, 1.0f);
            this._accum -= this._durations[this._phase];
            if (++this._phase != nphases) continue;
            this.completed();
            return;
        }
        this.update(this._phase, this._accum / this._durations[this._phase]);
    }

    protected void update(int phase, float pct) {
        this._pct = pct;
        this._cpct = 1.0f - pct;
        Method method = this._methods[phase];
        if (method != null) {
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error invoking method.", new Object[]{"method", method.getName(), e});
            }
        }
    }

    protected void completed() {
    }
}

