/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.export.Exportable;
import com.threerings.math.Matrix4f;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;

public final class Box
implements Exportable {
    public static final Box UNIT = new Box(Vector3f.UNIT_XYZ.negate(), Vector3f.UNIT_XYZ);
    public static final Box ZERO = new Box(Vector3f.ZERO, Vector3f.ZERO);
    public static final Box EMPTY = new Box(Vector3f.MAX_VALUE, Vector3f.MIN_VALUE);
    public static final Box MAX_VALUE = new Box(Vector3f.MIN_VALUE, Vector3f.MAX_VALUE);
    protected Vector3f _minExtent = new Vector3f();
    protected Vector3f _maxExtent = new Vector3f();

    public Box(Vector3f minExtent, Vector3f maxExtent) {
        this.set(minExtent, maxExtent);
    }

    public Box(Box other) {
        this.set(other);
    }

    public Box() {
        this.setToEmpty();
    }

    public Vector3f getMinimumExtent() {
        return this._minExtent;
    }

    public Vector3f getMaximumExtent() {
        return this._maxExtent;
    }

    public Vector3f getCenter() {
        return this.getCenter(new Vector3f());
    }

    public Vector3f getCenter(Vector3f result) {
        return this._minExtent.add(this._maxExtent, result).multLocal(0.5f);
    }

    public float getDiagonalLength() {
        return this._minExtent.distance(this._maxExtent);
    }

    public float getLongestEdge() {
        return Math.max(Math.max(this._maxExtent.x - this._minExtent.x, this._maxExtent.y - this._minExtent.y), this._maxExtent.z - this._minExtent.z);
    }

    public boolean isEmpty() {
        return this._minExtent.x > this._maxExtent.x || this._minExtent.y > this._maxExtent.y || this._minExtent.z > this._maxExtent.z;
    }

    public Box fromPoints(Vector3f ... points) {
        this.setToEmpty();
        Vector3f[] vector3fArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3f point = vector3fArray[n2];
            this.addLocal(point);
            ++n2;
        }
        return this;
    }

    public Box addLocal(Vector3f point) {
        return this.add(point, this);
    }

    public Box add(Vector3f point) {
        return this.add(point, new Box());
    }

    public Box add(Vector3f point, Box result) {
        result.getMinimumExtent().set(Math.min(this._minExtent.x, point.x), Math.min(this._minExtent.y, point.y), Math.min(this._minExtent.z, point.z));
        result.getMaximumExtent().set(Math.max(this._maxExtent.x, point.x), Math.max(this._maxExtent.y, point.y), Math.max(this._maxExtent.z, point.z));
        return result;
    }

    public Box addLocal(Box other) {
        return this.add(other, this);
    }

    public Box add(Box other) {
        return this.add(other, new Box());
    }

    public Box add(Box other, Box result) {
        Vector3f omin = other.getMinimumExtent();
        Vector3f omax = other.getMaximumExtent();
        result.getMinimumExtent().set(Math.min(this._minExtent.x, omin.x), Math.min(this._minExtent.y, omin.y), Math.min(this._minExtent.z, omin.z));
        result.getMaximumExtent().set(Math.max(this._maxExtent.x, omax.x), Math.max(this._maxExtent.y, omax.y), Math.max(this._maxExtent.z, omax.z));
        return result;
    }

    public Box intersectLocal(Box other) {
        return this.intersect(other, this);
    }

    public Box intersect(Box other) {
        return this.intersect(other, new Box());
    }

    public Box intersect(Box other, Box result) {
        Vector3f omin = other.getMinimumExtent();
        Vector3f omax = other.getMaximumExtent();
        result.getMinimumExtent().set(Math.max(this._minExtent.x, omin.x), Math.max(this._minExtent.y, omin.y), Math.max(this._minExtent.z, omin.z));
        result.getMaximumExtent().set(Math.min(this._maxExtent.x, omax.x), Math.min(this._maxExtent.y, omax.y), Math.min(this._maxExtent.z, omax.z));
        return result;
    }

    public Box transformLocal(Transform3D transform) {
        return this.transform(transform, this);
    }

    public Box transform(Transform3D transform) {
        return this.transform(transform, new Box());
    }

    public Box transform(Transform3D transform, Box result) {
        transform.update(3);
        Matrix4f matrix = transform.getMatrix();
        float minx = matrix.m00 * (matrix.m00 > 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m10 * (matrix.m10 > 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m20 * (matrix.m20 > 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m30;
        float miny = matrix.m01 * (matrix.m01 > 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m11 * (matrix.m11 > 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m21 * (matrix.m21 > 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m31;
        float minz = matrix.m02 * (matrix.m02 > 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m12 * (matrix.m12 > 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m22 * (matrix.m22 > 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m32;
        float maxx = matrix.m00 * (matrix.m00 < 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m10 * (matrix.m10 < 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m20 * (matrix.m20 < 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m30;
        float maxy = matrix.m01 * (matrix.m01 < 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m11 * (matrix.m11 < 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m21 * (matrix.m21 < 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m31;
        float maxz = matrix.m02 * (matrix.m02 < 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m12 * (matrix.m12 < 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m22 * (matrix.m22 < 0.0f ? this._minExtent.z : this._maxExtent.z) + matrix.m32;
        result.getMinimumExtent().set(minx, miny, minz);
        result.getMaximumExtent().set(maxx, maxy, maxz);
        return result;
    }

    public Box projectLocal(Matrix4f matrix) {
        return this.project(matrix, this);
    }

    public Box project(Matrix4f matrix) {
        return this.project(matrix, new Box());
    }

    public Box project(Matrix4f matrix, Box result) {
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float minz = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        float maxz = -3.4028235E38f;
        int ii = 0;
        while (ii < 8) {
            float x = (ii & 4) == 0 ? this._minExtent.x : this._maxExtent.x;
            float y = (ii & 2) == 0 ? this._minExtent.y : this._maxExtent.y;
            float z = (ii & 1) == 0 ? this._minExtent.z : this._maxExtent.z;
            float rw = 1.0f / (matrix.m03 * x + matrix.m13 * y + matrix.m23 * z + matrix.m33);
            float px = (matrix.m00 * x + matrix.m10 * y + matrix.m20 * z + matrix.m30) * rw;
            float py = (matrix.m01 * x + matrix.m11 * y + matrix.m21 * z + matrix.m31) * rw;
            float pz = (matrix.m02 * x + matrix.m12 * y + matrix.m22 * z + matrix.m32) * rw;
            minx = Math.min(minx, px);
            miny = Math.min(miny, py);
            minz = Math.min(minz, pz);
            maxx = Math.max(maxx, px);
            maxy = Math.max(maxy, py);
            maxz = Math.max(maxz, pz);
            ++ii;
        }
        result.getMinimumExtent().set(minx, miny, minz);
        result.getMaximumExtent().set(maxx, maxy, maxz);
        return result;
    }

    public Box expandLocal(float x, float y, float z) {
        return this.expand(x, y, z, this);
    }

    public Box expand(float x, float y, float z) {
        return this.expand(x, y, z, new Box());
    }

    public Box expand(float x, float y, float z, Box result) {
        result.getMinimumExtent().set(this._minExtent.x - x, this._minExtent.y - y, this._minExtent.z - z);
        result.getMaximumExtent().set(this._maxExtent.x + x, this._maxExtent.y + y, this._maxExtent.z + z);
        return result;
    }

    public Box setToEmpty() {
        return this.set(Vector3f.MAX_VALUE, Vector3f.MIN_VALUE);
    }

    public Box set(Box other) {
        return this.set(other.getMinimumExtent(), other.getMaximumExtent());
    }

    public Box set(Vector3f minExtent, Vector3f maxExtent) {
        this._minExtent.set(minExtent);
        this._maxExtent.set(maxExtent);
        return this;
    }

    public Vector3f getVertex(int code, Vector3f result) {
        return result.set((code & 4) == 0 ? this._minExtent.x : this._maxExtent.x, (code & 2) == 0 ? this._minExtent.y : this._maxExtent.y, (code & 1) == 0 ? this._minExtent.z : this._maxExtent.z);
    }

    public boolean contains(Vector3f point) {
        return this.contains(point.x, point.y, point.z);
    }

    public boolean contains(float x, float y, float z) {
        return x >= this._minExtent.x && x <= this._maxExtent.x && y >= this._minExtent.y && y <= this._maxExtent.y && z >= this._minExtent.z && z <= this._maxExtent.z;
    }

    public float getExtentDistance(Box other) {
        return other.getMinimumExtent().manhattanDistance(this._minExtent) + other.getMaximumExtent().manhattanDistance(this._maxExtent);
    }

    public boolean contains(Box other) {
        Vector3f omin = other._minExtent;
        Vector3f omax = other._maxExtent;
        return omin.x >= this._minExtent.x && omax.x <= this._maxExtent.x && omin.y >= this._minExtent.y && omax.y <= this._maxExtent.y && omin.z >= this._minExtent.z && omax.z <= this._maxExtent.z;
    }

    public boolean intersects(Box other) {
        Vector3f omin = other._minExtent;
        Vector3f omax = other._maxExtent;
        return this._maxExtent.x >= omin.x && this._minExtent.x <= omax.x && this._maxExtent.y >= omin.y && this._minExtent.y <= omax.y && this._maxExtent.z >= omin.z && this._minExtent.z <= omax.z;
    }

    public boolean intersects(Ray3D ray) {
        if (this.equals(MAX_VALUE)) {
            return true;
        }
        if (this.equals(EMPTY)) {
            return false;
        }
        Vector3f dir = ray.getDirection();
        return Math.abs(dir.x) > 1.0E-6f && (this.intersectsX(ray, this._minExtent.x) || this.intersectsX(ray, this._maxExtent.x)) || Math.abs(dir.y) > 1.0E-6f && (this.intersectsY(ray, this._minExtent.y) || this.intersectsY(ray, this._maxExtent.y)) || Math.abs(dir.z) > 1.0E-6f && (this.intersectsZ(ray, this._minExtent.z) || this.intersectsZ(ray, this._maxExtent.z));
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        Vector3f origin = ray.getOrigin();
        if (this.contains(origin)) {
            result.set(origin);
            return true;
        }
        Vector3f dir = ray.getDirection();
        float t = Float.MAX_VALUE;
        if (Math.abs(dir.x) > 1.0E-6f) {
            t = Math.min(t, this.getIntersectionX(ray, this._minExtent.x));
            t = Math.min(t, this.getIntersectionX(ray, this._maxExtent.x));
        }
        if (Math.abs(dir.y) > 1.0E-6f) {
            t = Math.min(t, this.getIntersectionY(ray, this._minExtent.y));
            t = Math.min(t, this.getIntersectionY(ray, this._maxExtent.y));
        }
        if (Math.abs(dir.z) > 1.0E-6f) {
            t = Math.min(t, this.getIntersectionZ(ray, this._minExtent.z));
            t = Math.min(t, this.getIntersectionZ(ray, this._maxExtent.z));
        }
        if (t == Float.MAX_VALUE) {
            return false;
        }
        origin.addScaled(dir, t, result);
        return true;
    }

    public String toString() {
        return "[min=" + this._minExtent + ", max=" + this._maxExtent + "]";
    }

    public int hashCode() {
        return this._minExtent.hashCode() + 31 * this._maxExtent.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Box)) {
            return false;
        }
        Box obox = (Box)other;
        return this._minExtent.equals(obox._minExtent) && this._maxExtent.equals(obox._maxExtent);
    }

    protected boolean intersectsX(Ray3D ray, float x) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (x - origin.x) / dir.x;
        if (t < 0.0f) {
            return false;
        }
        float iy = origin.y + t * dir.y;
        float iz = origin.z + t * dir.z;
        return iy >= this._minExtent.y && iy <= this._maxExtent.y && iz >= this._minExtent.z && iz <= this._maxExtent.z;
    }

    protected boolean intersectsY(Ray3D ray, float y) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (y - origin.y) / dir.y;
        if (t < 0.0f) {
            return false;
        }
        float ix = origin.x + t * dir.x;
        float iz = origin.z + t * dir.z;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x && iz >= this._minExtent.z && iz <= this._maxExtent.z;
    }

    protected boolean intersectsZ(Ray3D ray, float z) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (z - origin.z) / dir.z;
        if (t < 0.0f) {
            return false;
        }
        float ix = origin.x + t * dir.x;
        float iy = origin.y + t * dir.y;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x && iy >= this._minExtent.y && iy <= this._maxExtent.y;
    }

    protected float getIntersectionX(Ray3D ray, float x) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (x - origin.x) / dir.x;
        if (t < 0.0f) {
            return Float.MAX_VALUE;
        }
        float iy = origin.y + t * dir.y;
        float iz = origin.z + t * dir.z;
        return iy >= this._minExtent.y && iy <= this._maxExtent.y && iz >= this._minExtent.z && iz <= this._maxExtent.z ? t : Float.MAX_VALUE;
    }

    protected float getIntersectionY(Ray3D ray, float y) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (y - origin.y) / dir.y;
        if (t < 0.0f) {
            return Float.MAX_VALUE;
        }
        float ix = origin.x + t * dir.x;
        float iz = origin.z + t * dir.z;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x && iz >= this._minExtent.z && iz <= this._maxExtent.z ? t : Float.MAX_VALUE;
    }

    protected float getIntersectionZ(Ray3D ray, float z) {
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        float t = (z - origin.z) / dir.z;
        if (t < 0.0f) {
            return Float.MAX_VALUE;
        }
        float ix = origin.x + t * dir.x;
        float iy = origin.y + t * dir.y;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x && iy >= this._minExtent.y && iy <= this._maxExtent.y ? t : Float.MAX_VALUE;
    }
}

