/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.Primitives;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.config.NoDependency;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.Reference;
import com.threerings.config.util.ConfigId;
import com.threerings.config.util.FieldCache;
import com.threerings.editor.Property;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class DependencyGatherer {
    protected final FieldCache _fieldCache = new FieldCache((Predicate<? super Field>)Predicates.and(FieldCache.getDefaultPredicate(), (Predicate)new Predicate<Field>(){

        public boolean apply(Field f) {
            return !f.isSynthetic();
        }
    }));

    public static SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> gather(ConfigManager cfgmgr, ManagedConfig config) {
        return new Default(cfgmgr, config).getGathered();
    }

    protected abstract void add(Class<? extends ManagedConfig> var1, @Nullable ConfigReference<?> var2);

    protected void findReferences(ManagedConfig cfg) {
        Set seen = Sets.newIdentityHashSet();
        this.findReferences(cfg, cfg.getClass(), (Set<Object>)seen);
    }

    protected void findReferences(Object val, Type type, Set<Object> seen) {
        if (val == null) {
            return;
        }
        Class<?> c = val.getClass();
        if (c == String.class || c.isPrimitive() || Primitives.isWrapperType(c) || val instanceof ConfigManager || val instanceof Buffer || !seen.add(val)) {
            return;
        }
        if (val instanceof ConfigReference) {
            ConfigReference ref = (ConfigReference)val;
            Class<? extends ManagedConfig> clazz = this.getConfigReferenceType(type);
            if (clazz == null) {
                if (this.shouldWarn()) {
                    ClydeLog.log.warning((Object)("==== Found reference of unknown type: " + ref), new Object[0]);
                }
                return;
            }
            this.findReferences(ref, clazz, seen);
        } else if (c.isArray()) {
            Class<?> cType = c.getComponentType();
            int ii = 0;
            int nn = Array.getLength(val);
            while (ii < nn) {
                this.findReferences(Array.get(val, ii), cType, seen);
                ++ii;
            }
        } else if (val instanceof Collection) {
            Class<?> cType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : null;
            for (Object o : (Collection)val) {
                if (o == null) continue;
                Class<?> eType = cType != null ? cType : o.getClass();
                this.findReferences(o, eType, seen);
            }
        } else if (val instanceof DerivedConfig) {
            DerivedConfig dCfg = (DerivedConfig)val;
            this.findReferences(dCfg.base, dCfg.cclass, seen);
        } else {
            for (Field f : this._fieldCache.getFields(c)) {
                Object o;
                try {
                    o = f.get(val);
                }
                catch (IllegalAccessException iae) {
                    continue;
                }
                if (o instanceof ConfigReference && f.getAnnotation(NoDependency.class) != null) {
                    this.noteNoDependency((ConfigReference)o, f);
                    continue;
                }
                if (o instanceof String) {
                    String newValue;
                    Reference refAnno = f.getAnnotation(Reference.class);
                    if (refAnno == null || (newValue = this.addBareReference(refAnno.value(), (String)o)) == null) continue;
                    try {
                        f.set(val, newValue);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException(iae);
                    }
                }
                this.findReferences(o, f.getGenericType(), seen);
            }
        }
    }

    protected void noteNoDependency(ConfigReference<?> ref, Field f) {
    }

    protected void findReferences(ConfigReference<?> ref, Class<? extends ManagedConfig> clazz, Set<Object> seen) {
        this.add(clazz, ref);
        this.findArgumentReferences(ref, clazz, seen);
    }

    protected void findArgumentReferences(ConfigReference<?> ref, Class<? extends ManagedConfig> clazz, Set<Object> seen) {
        ConfigId id = new ConfigId(clazz, ref.getName());
        for (Map.Entry<String, Object> entry : ref.getArguments().entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            Class<? extends ManagedConfig> pclazz = this.getParameterConfigType(id, entry.getKey());
            if (pclazz != null) {
                if (value instanceof ConfigReference) {
                    this.findReferences((ConfigReference)value, pclazz, seen);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (ConfigReference pref : list) {
                        this.findReferences(pref, pclazz, seen);
                    }
                    continue;
                }
                ClydeLog.log.warning((Object)"Expected reference parameter but got something else.", new Object[]{"ref", ref, "clazz", clazz, "valueType", value.getClass(), "value", value});
                continue;
            }
            this.findReferences(value, value.getClass(), seen);
        }
    }

    protected String addBareReference(Class<? extends ManagedConfig> clazz, String cfgName) {
        this.add(clazz, new ConfigReference(cfgName));
        return null;
    }

    protected abstract Class<? extends ManagedConfig> getParameterConfigType(ConfigId var1, String var2);

    protected boolean shouldWarn() {
        return true;
    }

    protected Class<? extends ManagedConfig> getConfigReferenceType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type rawType = ptype.getRawType();
            if (ConfigReference.class.equals((Object)rawType)) {
                Class clazz = (Class)ptype.getActualTypeArguments()[0];
                return clazz;
            }
            if (List.class.equals((Object)rawType)) {
                return this.getConfigReferenceType(ptype.getActualTypeArguments()[0]);
            }
        }
        return null;
    }

    public static class Default
    extends DependencyGatherer {
        protected final ConfigManager _cfgmgr;
        protected final SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> _refs = HashMultimap.create();

        public Default(ConfigManager cfgmgr, ManagedConfig config) {
            this._cfgmgr = cfgmgr;
            this.findReferences(config);
        }

        public SetMultimap<Class<? extends ManagedConfig>, ConfigReference<?>> getGathered() {
            return Multimaps.unmodifiableSetMultimap(this._refs);
        }

        @Override
        protected void add(Class<? extends ManagedConfig> clazz, @Nullable ConfigReference<?> ref) {
            if (ref != null) {
                this._refs.put(clazz, ref);
            }
        }

        @Override
        protected Class<? extends ManagedConfig> getParameterConfigType(ConfigId id, String param) {
            ManagedConfig cfg = this._cfgmgr.getRawConfig(id.clazz, id.name);
            if (!(cfg instanceof ParameterizedConfig)) {
                ClydeLog.log.warning((Object)"Expected parameterized config, got none", new Object[]{"id", id, "cfg", cfg});
                return null;
            }
            ParameterizedConfig pcfg = (ParameterizedConfig)cfg;
            Parameter p = pcfg.getParameter(param);
            if (p == null) {
                ClydeLog.log.warning((Object)"Missing parameter!", new Object[]{"id", id, "param", param});
                return null;
            }
            Property prop = p.getProperty(pcfg);
            if (prop == null) {
                ClydeLog.log.warning((Object)"No property for parameter?", new Object[]{"id", id, "param", param});
                return null;
            }
            Reference refAnno = prop.getAnnotation(Reference.class);
            if (refAnno != null) {
                return refAnno.value();
            }
            return this.getConfigReferenceType(prop.getGenericType());
        }

        @Override
        protected void findArgumentReferences(ConfigReference<?> ref, Class<? extends ManagedConfig> clazz, Set<Object> seen) {
        }
    }

    public static abstract class PreExamined
    extends DependencyGatherer {
        protected final Table<ConfigId, String, Class<? extends ManagedConfig>> _paramCfgTypes = HashBasedTable.create();

        public PreExamined(ConfigManager cfgmgr) {
            for (ConfigGroup<?> group : cfgmgr.getGroups()) {
                Class<?> clazz = group.getConfigClass();
                for (ManagedConfig cfg : group.getRawConfigs()) {
                    this.populateParameters(clazz, cfg);
                }
            }
        }

        public void gather(ConfigManager cfgmgr) {
            for (ConfigGroup<?> group : cfgmgr.getGroups()) {
                for (ManagedConfig cfg : group.getRawConfigs()) {
                    this.findReferences(cfg);
                }
            }
        }

        protected void populateParameters(Class<? extends ManagedConfig> clazz, ManagedConfig cfg) {
            if (!(cfg instanceof ParameterizedConfig)) {
                return;
            }
            ParameterizedConfig pcfg = (ParameterizedConfig)cfg;
            ConfigId id = new ConfigId(clazz, cfg.getName());
            Parameter[] parameterArray = pcfg.parameters;
            int n = pcfg.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                Property prop = param.getProperty(pcfg);
                if (prop == null) {
                    ClydeLog.log.warning((Object)"No property for parameter?", new Object[]{"config", cfg.getName(), "class", clazz, "param", param.name});
                } else {
                    Class<? extends ManagedConfig> refClazz;
                    Reference refAnno = prop.getAnnotation(Reference.class);
                    if (refAnno != null) {
                        refClazz = refAnno.value();
                    } else {
                        refClazz = this.getConfigReferenceType(prop.getGenericType());
                        if (refClazz == null) {
                            refClazz = UnknownParameterTypeMarker.class;
                        }
                    }
                    this._paramCfgTypes.put((Object)id, (Object)param.name, refClazz);
                }
                ++n2;
            }
        }

        @Override
        protected Class<? extends ManagedConfig> getParameterConfigType(ConfigId id, String param) {
            Class value = (Class)this._paramCfgTypes.get((Object)id, (Object)param);
            if (value == null) {
                ClydeLog.log.warning((Object)"Bogus config and/or parameter! Ignoring.", new Object[]{"config", id, "parameter", param});
                return null;
            }
            return value == UnknownParameterTypeMarker.class ? null : value;
        }

        protected static class UnknownParameterTypeMarker
        extends ManagedConfig {
            protected UnknownParameterTypeMarker() {
            }
        }
    }
}

