package com.threerings.util;

import java.util.concurrent.ConcurrentHashMap;

import com.google.common.base.Function;

public class ComputingMap<K, V> extends ConcurrentHashMap<K, V> {
	private Function<K, V> _function;
	public ComputingMap(Function<K,V> function) {
		this._function = function;
	}
	
	public V get(Object key) {
		V v = super.get(key);
		if(v == null) {
			synchronized(key) {
				v = super.get(key);
				if(v == null) {
					v = _function.apply((K)key);
					this.put((K)key, (V)v);
				}
			}
		}
		
		return v;
	}
	
}
