package com.threerings.tudey.util;

import ognl.Ognl;
import ognl.OgnlException;

import com.samskivert.util.ConfigurationException;
import com.threerings.config.ConfigReference;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Actor;

public class OgnlFilter {
	
    
    public static String filter(String text, Object root)  {
        // String result = "";
    	if(text == null) return null;
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        for (; cur < textLen; cur = propStop + 1) {
            propStart = text.indexOf("#{", cur);
            if (propStart < 0) {
                break;
            }
            result.append(text.substring(cur, propStart));
            // result = result + text.substring(cur, propStart);
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            int  index = propName.indexOf(":");
            String defValue = null;
            String key = propName;
            if(index >0){
            	key = propName.substring(0,index);
            	defValue = propName.substring(index+1);
            }
            try {
				propValue = (String)Ognl.getValue(key,root,String.class);
			} catch (OgnlException e) {
				e.printStackTrace();
			}
            if (propValue == null) {
            	propValue = defValue;
            }
            result.append(propValue);
            // result = result + propValue;
        }
        
        String temp = result.append(text.substring(cur)).toString();
        if(temp.indexOf("#{")>=0){
            temp = filter(temp, root);
        }
        // result = result + text.substring(cur);
        return temp;
    }
    
    public static void main(String[] args) {
		class Hello {
			private Actor _actor;
			private String _name;
			public Actor getActor() {
				return _actor;
			}
			public void setActor(Actor _actor) {
				this._actor = _actor;
			}
			public String getName() {
				return _name;
			}
			public void setName(String _name) {
				this._name = _name;
			}
		}
		
		Hello hello = new Hello();
		Actor actor = new Actor(new ConfigReference<ActorConfig>("/hhello/test"),1234,0,new Vector2f(1,23),0.1f);
		hello.setActor(actor);
		System.out.println(OgnlFilter.filter(" hello_#{hashCode()}",hello));
		
	}
    
    
    
}
