package com.threerings.opengl.gui;

import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseListener;
import com.threerings.opengl.gui.event.MouseMotionListener;
import com.threerings.opengl.util.GlContext;

public class Moveable extends Component implements MouseMotionListener , MouseListener{
	private boolean dragging = false;
	private Window parent;
	
	float startX, startY, lastX, lastY;
	public Moveable(GlContext ctx) {
		super(ctx);
		
	    	
	    	MouseMotionListener ls = new MouseMotionListener() {
	    		
	    		float startX, startY, lastX, lastY;
				@Override
				public void mouseMoved(MouseEvent event) {
					
				}

				@Override
				public void mouseDragged(MouseEvent event) {
					dragging = true;
				}
	    		
	    	};
	    	/*
	    	new MouseMotionListener()  {
				float startX, startY, lastX, lastY;

				private void updateEdge (float x, float y) {
					float border = resizeBorder / 2f;
					float width = getWidth(), height = getHeight();
					float padTop = getPadTop(), padLeft = getPadLeft(), padBottom = getPadBottom(), padRight = getPadRight();
					float left = padLeft, right = width - padRight, bottom = padBottom;
					edge = 0;
					if (isResizable && x >= left - border && x <= right + border && y >= bottom - border) {
						if (x < left + border) edge |= Align.left;
						if (x > right - border) edge |= Align.right;
						if (y < bottom + border) edge |= Align.bottom;
						if (edge != 0) border += 25;
						if (x < left + border) edge |= Align.left;
						if (x > right - border) edge |= Align.right;
						if (y < bottom + border) edge |= Align.bottom;
					}
					if (isMovable && edge == 0 && y <= height && y >= height - padTop && x >= left && x <= right) edge = MOVE;
				}

				public boolean touchDown (InputEvent event, float x, float y, int pointer, int button) {
					if (button == 0) {
						updateEdge(x, y);
						dragging = edge != 0;
						startX = x;
						startY = y;
						lastX = x - getWidth();
						lastY = y - getHeight();
					}
					return edge != 0 || isModal;
				}

				public void touchUp (InputEvent event, float x, float y, int pointer, int button) {
					dragging = false;
				}

				public void touchDragged (InputEvent event, float x, float y, int pointer) {
					if (!dragging) return;
					float width = getWidth(), height = getHeight();
					float windowX = getX(), windowY = getY();

					float minWidth = getMinWidth(), maxWidth = getMaxWidth();
					float minHeight = getMinHeight(), maxHeight = getMaxHeight();
					Stage stage = getStage();
					boolean clampPosition = keepWithinStage && getParent() == stage.getRoot();

					if ((edge & MOVE) != 0) {
						float amountX = x - startX, amountY = y - startY;
						windowX += amountX;
						windowY += amountY;
					}
					if ((edge & Align.left) != 0) {
						float amountX = x - startX;
						if (width - amountX < minWidth) amountX = -(minWidth - width);
						if (clampPosition && windowX + amountX < 0) amountX = -windowX;
						width -= amountX;
						windowX += amountX;
					}
					if ((edge & Align.bottom) != 0) {
						float amountY = y - startY;
						if (height - amountY < minHeight) amountY = -(minHeight - height);
						if (clampPosition && windowY + amountY < 0) amountY = -windowY;
						height -= amountY;
						windowY += amountY;
					}
					if ((edge & Align.right) != 0) {
						float amountX = x - lastX - width;
						if (width + amountX < minWidth) amountX = minWidth - width;
						if (clampPosition && windowX + width + amountX > stage.getWidth()) amountX = stage.getWidth() - windowX - width;
						width += amountX;
					}
					if ((edge & Align.top) != 0) {
						float amountY = y - lastY - height;
						if (height + amountY < minHeight) amountY = minHeight - height;
						if (clampPosition && windowY + height + amountY > stage.getHeight())
							amountY = stage.getHeight() - windowY - height;
						height += amountY;
					}
					setBounds(Math.round(windowX), Math.round(windowY), Math.round(width), Math.round(height));
				}

			};*/
	}

	@Override
	public void mousePressed(MouseEvent event) {
		if(event.getButton() == MouseEvent.BUTTON1) {
			dragging = true;
		}
		
	}

	@Override
	public void mouseReleased(MouseEvent event) {
		if(event.getButton() == MouseEvent.BUTTON1) {
			dragging = false;
		}
		
	}

	@Override
	public void mouseClicked(MouseEvent event) {
		
	}

	@Override
	public void mouseEntered(MouseEvent event) {
		
	}

	@Override
	public void mouseExited(MouseEvent event) {
		
	}

	@Override
	public void mouseMoved(MouseEvent event) {
		lastX = event.getX();
		lastY = event.getY();
	}

	@Override
	public void mouseDragged(MouseEvent event) {
		int detaX = (int) (lastX - event.getX());
		int detaY = (int)(lastY - event.getY());
		parent.setLocation(parent._x - detaX , parent._y - detaY);
	}
	
	protected void wasAdded ()
    {
		super.wasAdded();
		Container container = this.getParent();
		while(container != null) {
			if(container instanceof Window) {
				this.parent = (Window)container;
				break;
			}
			
			container = container.getParent();
		}
    }
}
