/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.EntryState;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.EntryLogic;
import com.threerings.tudey.server.logic.Logic;
import java.util.Map;

public class EntryStateLogic
extends ActorLogic {
    protected ActionLogic[] _stateActions;
    protected EntryLogic _entry;

    public void setEntry(EntryLogic entry) {
        this._entry = entry;
        ((EntryState)this._actor).setKey(entry.getEntry().getKey());
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        EntryLogic entry = (EntryLogic)refs.get(((EntryStateLogic)source)._entry);
        if (entry != null) {
            this.setEntry(entry);
        }
        ActionLogic[] sactions = ((EntryStateLogic)source)._stateActions;
        int ii = 0;
        while (ii < this._stateActions.length) {
            this._stateActions[ii].transfer(sactions[ii], refs);
            ++ii;
        }
    }

    public void setState(int state, int entered) {
        int old = ((EntryState)this._actor).getState();
        if (state != old) {
            ((EntryState)this._actor).setState(state, entered);
            this.wasUpdated();
            if (this._stateActions.length >= state + 1 && this._stateActions[state] != null) {
                this._stateActions[state].execute(entered, this);
            }
        }
    }

    @Override
    protected void didInit() {
        super.didInit();
        ActorConfig.EntryState config = (ActorConfig.EntryState)this._config;
        this._stateActions = new ActionLogic[config.stateActions.length];
        int ii = 0;
        while (ii < this._stateActions.length) {
            this._stateActions[ii] = this.createAction(config.stateActions[ii], this);
            ++ii;
        }
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        int ii = 0;
        while (ii < this._stateActions.length) {
            if (this._stateActions[ii] != null) {
                this._stateActions[ii].removed();
            }
            ++ii;
        }
    }
}

