/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.cursor.AreaCursor;
import com.threerings.tudey.client.sprite.AreaSprite;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class AreaConfig
extends ParameterizedConfig {
    public static final Original NULL_ORIGINAL = new Original(Color4f.RED);
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public AreaCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, AreaCursor.Implementation impl) {
        return this.implementation.getCursorImplementation(ctx, scope, impl);
    }

    public AreaSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, AreaSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Conditional
    extends Original {
        @Editable(editor="mask", mode="collision", hgroup="e")
        public int collisionFlags = 0;
        @Editable(editor="mask", mode="collision", hgroup="e")
        public int satisfiedCollisionFlags = 0;
        @Editable(hgroup="f")
        public ConditionConfig condition = new ConditionConfig.Always();
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<AreaConfig> area;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(AreaConfig.class, this.area);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            AreaConfig config = cfgmgr.getConfig(AreaConfig.class, this.area);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        @Override
        public AreaCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, AreaCursor.Implementation impl) {
            AreaConfig config = ctx.getConfigManager().getConfig(AreaConfig.class, this.area);
            return config == null ? null : config.getCursorImplementation(ctx, scope, impl);
        }

        @Override
        public AreaSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, AreaSprite.Implementation impl) {
            AreaConfig config = ctx.getConfigManager().getConfig(AreaConfig.class, this.area);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    @EditorTypes(value={Original.class, Derived.class, MapRegion.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract AreaCursor.Implementation getCursorImplementation(TudeyContext var1, Scope var2, AreaCursor.Implementation var3);

        public abstract AreaSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, AreaSprite.Implementation var3);

        public void invalidate() {
        }
    }

    public static class MapRegion
    extends Original {
    }

    public static class Original
    extends Implementation {
        @Editable(mode="alpha", hgroup="c")
        @Strippable
        public Color4f color = new Color4f();
        @Editable(hgroup="c")
        @Strippable
        public boolean defaultEntrance;
        @Editable
        public TagConfig tags = new TagConfig();
        @Editable
        public HandlerConfig[] handlers = new HandlerConfig[0];

        public Original() {
        }

        public Original(Color4f color) {
            this.color.set(color);
        }

        public String getLogicClassName() {
            return this.tags.getLength() == 0 && this.handlers.length == 0 && !this.defaultEntrance ? null : "com.threerings.tudey.server.logic.EntryLogic";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            HandlerConfig[] handlerConfigArray = this.handlers;
            int n = this.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                HandlerConfig handler = handlerConfigArray[n2];
                handler.getPreloads(cfgmgr, preloads);
                ++n2;
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public AreaCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, AreaCursor.Implementation impl) {
            if (impl instanceof AreaCursor.Original) {
                ((AreaCursor.Original)impl).setConfig(this);
            } else {
                impl = new AreaCursor.Original(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public AreaSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, AreaSprite.Implementation impl) {
            if (!ScopeUtil.resolve(scope, "markersVisible", false).booleanValue()) {
                return null;
            }
            if (impl instanceof AreaSprite.Original) {
                ((AreaSprite.Original)impl).setConfig(this);
            } else {
                impl = new AreaSprite.Original(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void invalidate() {
            HandlerConfig[] handlerConfigArray = this.handlers;
            int n = this.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                HandlerConfig handler = handlerConfigArray[n2];
                handler.invalidate();
                ++n2;
            }
        }
    }
}

