/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing.filetree;

import com.threerings.swing.filetree.FileFilterPanel;
import com.threerings.swing.filetree.FileTree;
import com.threerings.swing.filetree.FileTreeNode;
import com.threerings.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class FileTreePanel
extends JPanel
implements MouseListener,
KeyListener {
    protected static FileSystemView fsv = FileSystemView.getFileSystemView();
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private FileTree tree;
    private JPopupMenu menu = null;
    private File _root;
    private FileFilter _filter;
    private FileFilterPanel _filterPanel;

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public FileTreePanel(File root, FileFilter filter, MessageManager msg) {
        this.setLayout(new BorderLayout());
        this._root = root;
        this._filter = filter;
        File[] roots = root.listFiles(filter);
        this.tree = new FileTree("resource-tree", this._filter, roots);
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.setRootVisible(false);
        JScrollPane jsp = new JScrollPane(this.tree);
        jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._filterPanel = new FileFilterPanel(msg);
        this.add((Component)this._filterPanel, "North");
        this.add((Component)jsp, "Center");
        this.menu = new JPopupMenu("");
        this.tree.add(this.menu);
        this._filterPanel.setTree(this.tree);
        JMenuItem refresh = new JMenuItem("Refresh");
        this.menu.add(refresh);
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath treePath = FileTreePanel.this.tree.getSelectionPath();
                Object obj = treePath.getLastPathComponent();
                if (obj instanceof FileTreeNode && !((FileTreeNode)obj).isFile()) {
                    ((FileTreeNode)obj).refresh();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileTreePanel.this.tree.updateUI();
                    }
                });
            }
        });
        JMenuItem copy = new JMenuItem("Copy Name");
        this.menu.add(copy);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = FileTreePanel.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object obj = path.getLastPathComponent();
                if (obj instanceof FileTreeNode && ((FileTreeNode)obj).isFile()) {
                    File file = ((FileTreeNode)obj).file;
                    StringBuilder builder = new StringBuilder(file.getName());
                    try {
                        File parent = file.getParentFile().getCanonicalFile();
                        File root = FileTreePanel.this._root.getCanonicalFile();
                        while (!root.equals(parent)) {
                            builder.insert(0, "/");
                            builder.insert(0, parent.getName());
                            parent = parent.getParentFile();
                        }
                        StringSelection selection = new StringSelection(builder.toString());
                        FileTreePanel.this.clipboard.setContents(selection, null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
    }

    public void setSearchFilter(FileFilter filter) {
        this.tree.setSearchFilter(filter);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        if (e.getButton() == 3) {
            this.menu.show(this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 67 && e.isControlDown()) {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof FileTreeNode) {
                if (((FileTreeNode)obj).isFile()) {
                    File file = ((FileTreeNode)obj).file;
                    StringBuilder builder = new StringBuilder(file.getName());
                    try {
                        File parent = file.getParentFile().getCanonicalFile();
                        File root = this._root.getCanonicalFile();
                        while (!root.equals(parent)) {
                            builder.insert(0, "/");
                            builder.insert(0, parent.getName());
                            parent = parent.getParentFile();
                        }
                        StringSelection selection = new StringSelection(builder.toString());
                        this.clipboard.setContents(selection, null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public static void main(String[] args) throws Exception {
        File file = new File("../");
        System.out.println(file.getCanonicalPath());
    }

    private static class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Map<File, String> rootNameCache = new HashMap<File, String>();

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileTreeNode ftn = (FileTreeNode)value;
            File file = ftn.file;
            String filename = "";
            if (file != null) {
                if (ftn.isFileSystemRoot) {
                    filename = this.rootNameCache.get(file);
                    if (filename == null) {
                        filename = fsv.getSystemDisplayName(file);
                        this.rootNameCache.put(file, filename);
                    }
                } else {
                    filename = file.getName();
                }
            }
            JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, filename, sel, expanded, leaf, row, hasFocus);
            if (file != null) {
                Icon icon = this.iconCache.get(filename);
                if (icon == null) {
                    icon = fsv.getSystemIcon(file);
                    this.iconCache.put(filename, icon);
                }
                result.setIcon(icon);
            }
            return result;
        }
    }
}

